/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.climate.ClimateCapabilities;
import forestry.api.climate.IClimateListener;
import forestry.api.climate.IClimateManager;
import forestry.api.climate.IClimateProvider;
import forestry.api.climate.IClimateState;
import forestry.api.climate.IWorldClimateHolder;
import forestry.core.DefaultClimateProvider;
import forestry.core.climate.ClimateStateHelper;
import forestry.core.climate.WorldClimateHolder;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class ClimateRoot
implements IClimateManager {
    private static final ClimateRoot INSTANCE = new ClimateRoot();

    public static ClimateRoot getInstance() {
        return INSTANCE;
    }

    @Override
    @Nullable
    public IClimateListener getListener(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity.hasCapability(ClimateCapabilities.CLIMATE_LISTENER, null)) {
            return (IClimateListener)tileEntity.getCapability(ClimateCapabilities.CLIMATE_LISTENER, null);
        }
        return null;
    }

    @Override
    public IClimateProvider getDefaultClimate(World world, BlockPos pos) {
        return new DefaultClimateProvider(world, pos);
    }

    @Override
    public IClimateState getState(World world, BlockPos pos) {
        IWorldClimateHolder climateHolder = this.getWorldClimate(world);
        return climateHolder.getState(pos);
    }

    @Override
    public IClimateState getBiomeState(World worldObj, BlockPos coordinates) {
        Biome biome = worldObj.func_180494_b(coordinates);
        return ClimateStateHelper.of(biome.func_180626_a(coordinates), biome.func_76727_i());
    }

    @Override
    public IWorldClimateHolder getWorldClimate(World world) {
        MapStorage storage = world.getPerWorldStorage();
        WorldClimateHolder holder = (WorldClimateHolder)storage.func_75742_a(WorldClimateHolder.class, "forestry_climate");
        if (holder == null) {
            holder = new WorldClimateHolder("forestry_climate");
            storage.func_75745_a("forestry_climate", (WorldSavedData)holder);
        }
        holder.setWorld(world);
        return holder;
    }
}

