/*
 * Decompiled with CFR 0.152.
 */
package forestry.book.gui;

import forestry.api.book.IForesterBook;
import forestry.book.gui.buttons.GuiButtonBack;
import forestry.book.gui.buttons.GuiButtonPage;
import forestry.core.gui.GuiWindow;
import forestry.core.gui.IGuiSizable;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GuiForesterBook
extends GuiWindow
implements IGuiSizable {
    public static final ResourceLocation TEXTURE = new ResourceLocation("forestry", "textures/gui/almanac/almanac.png");
    static final int LEFT_PAGE_START_X = 16;
    static final int RIGHT_PAGE_START_X = 132;
    static final int PAGE_START_Y = 12;
    static final int LEFT_PAGE_START_Y = 25;
    static final int RIGHT_PAGE_START_Y = 12;
    public static final int PAGE_WIDTH = 108;
    public static final int PAGE_HEIGHT = 155;
    private static final int X_SIZE = 256;
    private static final int Y_SIZE = 181;
    @Nullable
    private static GuiForesterBook guiScreen;
    protected final IForesterBook book;

    protected GuiForesterBook(IForesterBook book) {
        super(256, 181);
        this.book = book;
        GuiForesterBook.setGuiScreen(this);
    }

    public IForesterBook getBook() {
        return this.book;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        if (this.hasButtons()) {
            GuiButtonPage leftButton = (GuiButtonPage)this.func_189646_b(new GuiButtonPage(0, this.guiLeft + 24, this.guiTop + 181 - 20, true));
            GuiButtonPage rightButton = (GuiButtonPage)this.func_189646_b(new GuiButtonPage(1, this.guiLeft + 256 - 44, this.guiTop + 181 - 20, false));
            GuiButtonBack backButton = (GuiButtonBack)this.func_189646_b(new GuiButtonBack(2, this.guiLeft + 128 - 12, this.guiTop + 181 - 20));
            this.initButtons(leftButton, rightButton, backButton);
        }
    }

    protected boolean hasButtons() {
        return true;
    }

    protected void initButtons(GuiButtonPage leftButton, GuiButtonPage rightButton, GuiButtonBack backButton) {
    }

    @Override
    public boolean func_73868_f() {
        return false;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        TextureManager manager = this.field_146297_k.field_71446_o;
        manager.func_110577_a(TEXTURE);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 256, 181);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        boolean unicode = this.field_146289_q.func_82883_a();
        this.field_146289_q.func_78264_a(true);
        this.func_73732_a(this.field_146289_q, TextFormatting.UNDERLINE + this.getTitle(), this.guiLeft + 16 + 52, this.guiTop + 12, 0xD3D3D3);
        this.drawText();
        this.field_146289_q.func_78264_a(unicode);
        this.drawTooltips(mouseX, mouseY);
    }

    @Override
    protected void drawTooltips(int mouseX, int mouseY) {
        List<String> tooltip;
        super.drawTooltips(mouseX, mouseY);
        InventoryPlayer playerInv = this.field_146297_k.field_71439_g.field_71071_by;
        if (playerInv.func_70445_o().func_190926_b() && !(tooltip = this.getTooltip(mouseX, mouseY)).isEmpty()) {
            ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k);
            GuiUtils.drawHoveringText(tooltip, (int)mouseX, (int)mouseY, (int)scaledresolution.func_78326_a(), (int)scaledresolution.func_78328_b(), (int)-1, (FontRenderer)this.field_146289_q);
        }
    }

    protected void drawText() {
    }

    protected List<String> getTooltip(int mouseX, int mouseY) {
        return Collections.emptyList();
    }

    protected abstract String getTitle();

    @Nullable
    public static GuiForesterBook getGuiScreen() {
        return guiScreen;
    }

    public static void setGuiScreen(@Nullable GuiForesterBook guiScreen) {
        GuiForesterBook.guiScreen = guiScreen;
    }
}

