/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.arboriculture.IGermlingModelProvider;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.arboriculture.IWoodType;
import forestry.arboriculture.models.ModelProviderGermling;
import forestry.arboriculture.models.ModelProviderGermlingVanilla;

public class ModelProviderFactory {
    public static IGermlingModelProvider create(IWoodType woodType, String modelUid, ILeafSpriteProvider leafSpriteProvider) {
        if (woodType instanceof EnumVanillaWoodType) {
            return new ModelProviderGermlingVanilla((EnumVanillaWoodType)woodType, leafSpriteProvider);
        }
        if (woodType instanceof EnumForestryWoodType) {
            return new ModelProviderGermling(modelUid, leafSpriteProvider);
        }
        throw new IllegalArgumentException("Unknown wood type: " + woodType);
    }
}

