/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.commands;

import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.core.commands.SpeciesNotFoundException;
import forestry.core.utils.BlockUtil;
import forestry.core.worldgen.WorldGenBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public final class TreeGenHelper {
    public static WorldGenerator getWorldGen(String treeName, EntityPlayer player, BlockPos pos) throws SpeciesNotFoundException {
        ITreeGenome treeGenome = TreeGenHelper.getTreeGenome(treeName);
        ITree tree = TreeManager.treeRoot.getTree(player.field_70170_p, treeGenome);
        return tree.getTreeGenerator(player.field_70170_p, pos, true);
    }

    public static boolean generateTree(WorldGenerator gen, World world, BlockPos pos) {
        if ((pos = pos.func_177956_o() > 0 && world.func_175623_d(pos.func_177977_b()) ? BlockUtil.getNextSolidDownPos(world, pos) : BlockUtil.getNextReplaceableUpPos(world, pos)) == null) {
            return false;
        }
        IBlockState blockState = world.func_180495_p(pos);
        if (BlockUtil.canPlaceTree(blockState, world, pos)) {
            if (gen instanceof WorldGenBase) {
                return ((WorldGenBase)gen).generate(world, world.field_73012_v, pos, true);
            }
            return gen.func_180709_b(world, world.field_73012_v, pos);
        }
        return false;
    }

    public static boolean generateTree(ITree tree, World world, BlockPos pos) {
        WorldGenerator gen = tree.getTreeGenerator(world, pos, true);
        IBlockState blockState = world.func_180495_p(pos);
        if (BlockUtil.canPlaceTree(blockState, world, pos)) {
            if (gen instanceof WorldGenBase) {
                return ((WorldGenBase)gen).generate(world, world.field_73012_v, pos, true);
            }
            return gen.func_180709_b(world, world.field_73012_v, pos);
        }
        return false;
    }

    private static ITreeGenome getTreeGenome(String speciesName) throws SpeciesNotFoundException {
        IAlleleTreeSpecies species = null;
        for (String uid : AlleleManager.alleleRegistry.getRegisteredAlleles().keySet()) {
            IAllele allele;
            if (!uid.equals(speciesName) || !((allele = AlleleManager.alleleRegistry.getAllele(uid)) instanceof IAlleleTreeSpecies)) continue;
            species = (IAlleleTreeSpecies)allele;
            break;
        }
        if (species == null) {
            for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
                if (!(allele instanceof IAlleleTreeSpecies) || !allele.getAlleleName().replaceAll("\\s", "").equals(speciesName)) continue;
                species = (IAlleleTreeSpecies)allele;
                break;
            }
        }
        if (species == null) {
            throw new SpeciesNotFoundException(speciesName);
        }
        IAllele[] template = TreeManager.treeRoot.getTemplate(species);
        return TreeManager.treeRoot.templateAsGenome(template);
    }
}

