/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.DatabaseMode;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IDatabaseTab;
import forestry.api.gui.GuiElementAlignment;
import forestry.api.gui.IDatabaseElement;
import forestry.api.gui.style.ITextStyle;
import forestry.api.gui.style.TextStyleBuilder;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.core.genetics.alleles.AlleleBoolean;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.render.ColourProperties;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Translator;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BeeDatabaseTab
implements IDatabaseTab<IBee> {
    private static final ITextStyle BINOMIAL = new TextStyleBuilder().color(() -> ColourProperties.INSTANCE.get("gui.beealyzer.binomial")).build();
    private final DatabaseMode mode;

    BeeDatabaseTab(DatabaseMode mode) {
        this.mode = mode;
    }

    @Override
    public DatabaseMode getMode() {
        return this.mode;
    }

    @Override
    public void createElements(IDatabaseElement container, IBee bee, ItemStack itemStack) {
        String nocturnal;
        String diurnal;
        EnumBeeType type = BeeManager.beeRoot.getType(itemStack);
        if (type == null) {
            return;
        }
        IAlleleBeeSpecies primarySpecies = bee.getGenome().getPrimary();
        IAlleleBeeSpecies secondarySpecies = bee.getGenome().getSecondary();
        container.label(Translator.translateToLocal("for.gui.database.tab." + (this.mode == DatabaseMode.ACTIVE ? "active" : "inactive") + "_species.name"), GuiElementAlignment.TOP_CENTER, GuiElementFactory.DATABASE_TITLE);
        container.addLine(Translator.translateToLocal("for.gui.species"), EnumBeeChromosome.SPECIES);
        Function<Boolean, String> toleranceText = a -> {
            IAlleleSpecies species = a != false ? primarySpecies : secondarySpecies;
            return AlleleManager.climateHelper.toDisplay(species.getTemperature());
        };
        container.addLine(Translator.translateToLocal("for.gui.climate"), toleranceText, (IChromosomeType)EnumBeeChromosome.TEMPERATURE_TOLERANCE);
        container.addToleranceLine(EnumBeeChromosome.TEMPERATURE_TOLERANCE);
        container.addLine(Translator.translateToLocal("for.gui.humidity"), toleranceText, (IChromosomeType)EnumBeeChromosome.HUMIDITY_TOLERANCE);
        container.addToleranceLine(EnumBeeChromosome.HUMIDITY_TOLERANCE);
        container.addLine(Translator.translateToLocal("for.gui.lifespan"), EnumBeeChromosome.LIFESPAN);
        container.addLine(Translator.translateToLocal("for.gui.speed"), EnumBeeChromosome.SPEED);
        container.addLine(Translator.translateToLocal("for.gui.pollination"), EnumBeeChromosome.FLOWERING);
        container.addLine(Translator.translateToLocal("for.gui.flowers"), EnumBeeChromosome.FLOWER_PROVIDER);
        container.addFertilityLine(Translator.translateToLocal("for.gui.fertility"), EnumBeeChromosome.FERTILITY, 0);
        container.addLine(Translator.translateToLocal("for.gui.area"), EnumBeeChromosome.TERRITORY);
        container.addLine(Translator.translateToLocal("for.gui.effect"), EnumBeeChromosome.EFFECT);
        String yes = Translator.translateToLocal("for.yes");
        String no = Translator.translateToLocal("for.no");
        if (this.mode == DatabaseMode.ACTIVE) {
            if (bee.getGenome().getNeverSleeps()) {
                nocturnal = diurnal = yes;
            } else {
                nocturnal = bee.getGenome().getPrimary().isNocturnal() ? yes : no;
                diurnal = !bee.getGenome().getPrimary().isNocturnal() ? yes : no;
            }
        } else if (((AlleleBoolean)bee.getGenome().getInactiveAllele(EnumButterflyChromosome.NOCTURNAL)).getValue()) {
            nocturnal = diurnal = yes;
        } else {
            nocturnal = bee.getGenome().getSecondary().isNocturnal() ? yes : no;
            diurnal = !bee.getGenome().getSecondary().isNocturnal() ? yes : no;
        }
        container.addLine(Translator.translateToLocal("for.gui.diurnal"), diurnal, false);
        container.addLine(Translator.translateToLocal("for.gui.nocturnal"), nocturnal, false);
        Function<Boolean, String> flyer = active -> StringUtil.readableBoolean(active != false ? bee.getGenome().getToleratesRain() : ((AlleleBoolean)bee.getGenome().getInactiveAllele(EnumBeeChromosome.TOLERATES_RAIN)).getValue(), yes, no);
        container.addLine(Translator.translateToLocal("for.gui.flyer"), flyer, (IChromosomeType)EnumBeeChromosome.TOLERATES_RAIN);
        Function<Boolean, String> cave = active -> StringUtil.readableBoolean(active != false ? bee.getGenome().getCaveDwelling() : ((AlleleBoolean)bee.getGenome().getInactiveAllele(EnumBeeChromosome.CAVE_DWELLING)).getValue(), yes, no);
        container.addLine(Translator.translateToLocal("for.gui.cave"), cave, (IChromosomeType)EnumBeeChromosome.CAVE_DWELLING);
        if (type == EnumBeeType.PRINCESS || type == EnumBeeType.QUEEN) {
            String displayTextKey = "for.bees.stock.pristine";
            if (!bee.isNatural()) {
                displayTextKey = "for.bees.stock.ignoble";
            }
            String displayText = Translator.translateToLocal(displayTextKey);
            container.label(displayText, GuiElementAlignment.TOP_CENTER, BINOMIAL);
        }
    }

    @Override
    public ItemStack getIconStack() {
        return BeeDefinition.MEADOWS.getMemberStack(this.mode == DatabaseMode.ACTIVE ? EnumBeeType.PRINCESS : EnumBeeType.DRONE);
    }
}

