/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.rftoolssupport;

import com.google.common.base.Function;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.network.NetworkTools;
import mcjty.rftools.api.screens.IScreenModuleRegistry;
import mcjty.rftoolscontrol.blocks.vectorart.GfxOp;
import mcjty.rftoolscontrol.logic.ParameterTools;
import mcjty.rftoolscontrol.rftoolssupport.ModuleDataLog;
import mcjty.rftoolscontrol.rftoolssupport.ModuleDataVariable;
import mcjty.rftoolscontrol.rftoolssupport.ModuleDataVectorArt;

public class RFToolsSupport {
    private static List<GfxOp> readGfxOp(ByteBuf buf) {
        int size = buf.readInt();
        if (size == 0) {
            return null;
        }
        ArrayList<GfxOp> operations = new ArrayList<GfxOp>(size);
        for (int i = 0; i < size; ++i) {
            GfxOp op = GfxOp.readFromBuf(buf);
            operations.add(op);
        }
        return operations;
    }

    private static List<String> readLog(ByteBuf buf) {
        int size = buf.readInt();
        if (size == 0) {
            return null;
        }
        ArrayList<String> rc = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            rc.add(NetworkTools.readString((ByteBuf)buf));
        }
        return rc;
    }

    public static class GetScreenModuleRegistry
    implements Function<IScreenModuleRegistry, Void> {
        @Nullable
        public Void apply(IScreenModuleRegistry manager) {
            manager.registerModuleDataFactory("rftoolscontrol:VAR", buf -> new ModuleDataVariable(ParameterTools.readFromBuf(buf)));
            manager.registerModuleDataFactory("rftoolscontrol:LOG", buf -> new ModuleDataLog(RFToolsSupport.readLog(buf)));
            manager.registerModuleDataFactory("rftoolscontrol:VECTOR", buf -> new ModuleDataVectorArt(RFToolsSupport.readGfxOp(buf)));
            return null;
        }
    }
}

