/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.network;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import mcjty.rftoolscontrol.api.parameters.Parameter;
import mcjty.rftoolscontrol.api.parameters.ParameterType;
import mcjty.rftoolscontrol.api.parameters.ParameterValue;
import mcjty.rftoolscontrol.blocks.processor.ProcessorTileEntity;
import mcjty.rftoolscontrol.logic.registry.ParameterTypeTools;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketVariableToServer
implements IMessage {
    private BlockPos pos;
    private int varIndex;
    private NBTTagCompound tagCompound;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.varIndex = buf.readInt();
        this.tagCompound = NetworkTools.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        buf.writeInt(this.varIndex);
        NetworkTools.writeTag((ByteBuf)buf, (NBTTagCompound)this.tagCompound);
    }

    public PacketVariableToServer() {
    }

    public PacketVariableToServer(BlockPos pos, int varIndex, NBTTagCompound tagCompound) {
        this.pos = pos;
        this.varIndex = varIndex;
        this.tagCompound = tagCompound;
    }

    public static class Handler
    implements IMessageHandler<PacketVariableToServer, IMessage> {
        public IMessage onMessage(PacketVariableToServer message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketVariableToServer message, MessageContext ctx) {
            EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
            TileEntity te = playerEntity.func_130014_f_().func_175625_s(message.pos);
            if (te instanceof ProcessorTileEntity) {
                ProcessorTileEntity processor = (ProcessorTileEntity)te;
                Parameter[] variables = processor.getVariableArray();
                if (message.varIndex < variables.length) {
                    Parameter parameter = variables[message.varIndex];
                    ParameterType type = parameter.getParameterType();
                    ParameterValue value = ParameterTypeTools.readFromNBT(message.tagCompound, type);
                    variables[((PacketVariableToServer)message).varIndex] = Parameter.builder().type(type).value(value).build();
                    processor.func_70296_d();
                }
            }
        }
    }
}

