/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.grid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import mcjty.rftoolscontrol.logic.grid.GridInstance;
import mcjty.rftoolscontrol.logic.grid.GridPos;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ProgramCardInstance {
    private Map<GridPos, GridInstance> gridInstances = new HashMap<GridPos, GridInstance>();

    public Map<GridPos, GridInstance> getGridInstances() {
        return this.gridInstances;
    }

    private ProgramCardInstance() {
    }

    public static ProgramCardInstance newInstance() {
        return new ProgramCardInstance();
    }

    public static ProgramCardInstance parseInstance(ItemStack card) {
        NBTTagCompound tagCompound = card.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        ProgramCardInstance instance = new ProgramCardInstance();
        NBTTagList grid = tagCompound.func_150295_c("grid", 10);
        for (int i = 0; i < grid.func_74745_c(); ++i) {
            NBTTagCompound gridElement = (NBTTagCompound)grid.func_179238_g(i);
            ProgramCardInstance.parseElement(gridElement, instance);
        }
        return instance;
    }

    private static void parseElement(NBTTagCompound tag, ProgramCardInstance instance) {
        int x = tag.func_74762_e("x");
        int y = tag.func_74762_e("y");
        GridInstance gi = GridInstance.readFromNBT(tag);
        if (gi != null) {
            instance.putGridInstance(x, y, gi);
        }
    }

    public void putGridInstance(int x, int y, GridInstance gridInstance) {
        this.gridInstances.put(GridPos.pos(x, y), gridInstance);
    }

    public static ProgramCardInstance readFromJson(String json) {
        JsonParser parser = new JsonParser();
        JsonElement root = parser.parse(json);
        ProgramCardInstance instance = new ProgramCardInstance();
        for (JsonElement entry : root.getAsJsonArray()) {
            JsonElement posElement = entry.getAsJsonObject().get("pos");
            JsonElement gridElement = entry.getAsJsonObject().get("opcode");
            int x = posElement.getAsJsonObject().get("x").getAsInt();
            int y = posElement.getAsJsonObject().get("y").getAsInt();
            GridInstance gi = GridInstance.readFromJson(gridElement);
            if (gi == null) continue;
            instance.putGridInstance(x, y, gi);
        }
        return instance;
    }

    public String writeToJson() {
        JsonArray array = new JsonArray();
        for (Map.Entry<GridPos, GridInstance> entry : this.gridInstances.entrySet()) {
            GridPos coordinate = entry.getKey();
            GridInstance gridInstance = entry.getValue();
            JsonObject ruleObject = new JsonObject();
            ruleObject.add("pos", this.buildCoordinateElement(coordinate));
            ruleObject.add("opcode", gridInstance.getJsonElement());
            array.add((JsonElement)ruleObject);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)array);
    }

    private JsonElement buildCoordinateElement(GridPos pos) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("x", (JsonElement)new JsonPrimitive((Number)pos.getX()));
        jsonObject.add("y", (JsonElement)new JsonPrimitive((Number)pos.getY()));
        return jsonObject;
    }

    public void writeToNBT(ItemStack card) {
        NBTTagCompound tagCompound = card.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            card.func_77982_d(tagCompound);
        }
        NBTTagList grid = new NBTTagList();
        for (Map.Entry<GridPos, GridInstance> entry : this.gridInstances.entrySet()) {
            GridPos coordinate = entry.getKey();
            int x = coordinate.getX();
            int y = coordinate.getY();
            GridInstance gridInstance = entry.getValue();
            NBTTagCompound tag = gridInstance.writeToNBT(x, y);
            grid.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("grid", (NBTBase)grid);
    }
}

