/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.editors;

import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.rftoolscontrol.api.parameters.ParameterType;
import mcjty.rftoolscontrol.api.parameters.ParameterValue;
import mcjty.rftoolscontrol.logic.TypeConverters;
import mcjty.rftoolscontrol.logic.editors.AbstractParameterEditor;
import mcjty.rftoolscontrol.logic.editors.ParameterEditorCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class NumberEditor
extends AbstractParameterEditor {
    private ChoiceLabel typeLabel;
    private TextField field;

    @Override
    public int getHeight() {
        return 40;
    }

    @Override
    public void build(Minecraft mc, Gui gui, Panel panel, ParameterEditorCallback callback) {
        Panel constantPanel = new Panel(mc, gui).setLayout((Layout)new VerticalLayout());
        this.typeLabel = (ChoiceLabel)new ChoiceLabel(mc, gui).addChoices(new String[]{"Integer", "Long", "Float", "Double"}).addChoiceEvent((parent, newChoice) -> callback.valueChanged(this.readValue())).setDesiredWidth(60);
        constantPanel.addChild((Widget)this.createLabeledPanel(mc, gui, "Type:", (Widget<?>)this.typeLabel, "Type of the number"));
        this.field = new TextField(mc, gui).addTextEvent((parent, newText) -> callback.valueChanged(this.readValue())).addTextEnterEvent((parent, newText) -> this.closeWindow());
        constantPanel.addChild((Widget)this.field);
        this.createEditorPanel(mc, gui, panel, callback, constantPanel, ParameterType.PAR_NUMBER);
    }

    @Override
    public void initialFocusInternal(Window window) {
        window.setTextFocus((Widget)this.field);
    }

    @Override
    protected ParameterValue readConstantValue() {
        String choice = this.typeLabel.getCurrentChoice().toLowerCase();
        if (choice.startsWith("i")) {
            return ParameterValue.constant(NumberEditor.parseIntSafe(this.field.getText()));
        }
        if (choice.startsWith("l")) {
            return ParameterValue.constant(NumberEditor.parseLongSafe(this.field.getText()));
        }
        if (choice.startsWith("f")) {
            return ParameterValue.constant(NumberEditor.parseFloatSafe(this.field.getText()));
        }
        if (choice.startsWith("d")) {
            return ParameterValue.constant(NumberEditor.parseDoubleSafe(this.field.getText()));
        }
        return ParameterValue.constant(0);
    }

    @Override
    protected void writeConstantValue(ParameterValue value) {
        if (value == null || value.getValue() == null) {
            this.field.setText("");
        } else {
            Object v = value.getValue();
            if (v instanceof Integer || v == null) {
                this.typeLabel.setChoice("Integer");
            } else if (v instanceof Long) {
                this.typeLabel.setChoice("Long");
            } else if (v instanceof Float) {
                this.typeLabel.setChoice("Float");
            } else if (v instanceof Double) {
                this.typeLabel.setChoice("Double");
            }
            String s = TypeConverters.castNumberToString(v);
            this.field.setText(s);
        }
    }
}

