/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.compiled;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mcjty.rftoolscontrol.api.code.Opcode;
import mcjty.rftoolscontrol.api.parameters.Parameter;
import mcjty.rftoolscontrol.api.parameters.ParameterDescription;
import mcjty.rftoolscontrol.logic.grid.GridInstance;
import mcjty.rftoolscontrol.logic.grid.GridPos;
import mcjty.rftoolscontrol.logic.grid.ProgramCardInstance;
import mcjty.rftoolscontrol.logic.registry.Opcodes;
import org.apache.commons.lang3.tuple.Pair;

public class ProgramValidator {
    public static List<Pair<GridPos, String>> validate(ProgramCardInstance program) {
        GridInstance g;
        ArrayList<Pair<GridPos, String>> errors = new ArrayList<Pair<GridPos, String>>();
        Map<GridPos, GridInstance> grid = program.getGridInstances();
        HashSet<GridPos> reachableLocations = new HashSet<GridPos>();
        for (Map.Entry<GridPos, GridInstance> entry : grid.entrySet()) {
            g = entry.getValue();
            if (g.getPrimaryConnection() != null) {
                reachableLocations.add(g.getPrimaryConnection().offset(entry.getKey()));
            }
            if (g.getSecondaryConnection() == null) continue;
            reachableLocations.add(g.getSecondaryConnection().offset(entry.getKey()));
        }
        for (Map.Entry<GridPos, GridInstance> entry : grid.entrySet()) {
            g = entry.getValue();
            Opcode opcode = Opcodes.OPCODES.get(g.getId());
            GridPos p = entry.getKey();
            if (opcode.isEvent() || reachableLocations.contains(p)) continue;
            errors.add((Pair<GridPos, String>)Pair.of((Object)p, (Object)("Unreachable: " + p.getX() + "," + p.getY())));
        }
        for (Map.Entry<GridPos, GridInstance> entry : grid.entrySet()) {
            GridPos p = entry.getKey();
            GridInstance g2 = entry.getValue();
            Opcode opcode = Opcodes.OPCODES.get(g2.getId());
            List<ParameterDescription> descriptions = opcode.getParameters();
            List<Parameter> parameters = g2.getParameters();
            for (int i = 0; i < descriptions.size(); ++i) {
                Parameter par;
                ParameterDescription desc = descriptions.get(i);
                Parameter parameter = par = i < parameters.size() ? parameters.get(i) : null;
                if (desc.isOptional() || par != null && par.getParameterValue() != null && (!par.getParameterValue().isConstant() || par.getParameterValue().getValue() != null)) continue;
                errors.add((Pair<GridPos, String>)Pair.of((Object)p, (Object)("Missing parameter (" + desc.getName() + "): " + p.getX() + "," + p.getY())));
            }
        }
        return errors;
    }
}

