/*
 * Decompiled with CFR 0.152.
 */
package com.mramericanmike.bqt.utils;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mramericanmike.bqt.configuration.ConfigurationHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class RecipeToJson {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static File RECIPE_DIR = null;
    private static final Set<String> USED_OD_NAMES = new TreeSet<String>();

    private static void setupDir() {
        if (RECIPE_DIR == null) {
            RECIPE_DIR = ConfigurationHandler.configuration.getConfigFile().toPath().resolve("../recipes/").toFile();
        }
        if (!RECIPE_DIR.exists()) {
            RECIPE_DIR.mkdir();
        }
    }

    public static void addShapedRecipe(ItemStack result, Object ... components) {
        int i;
        RecipeToJson.setupDir();
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<String> pattern = new ArrayList<String>();
        for (i = 0; i < components.length && components[i] instanceof String; ++i) {
            pattern.add((String)components[i]);
        }
        json.put("pattern", pattern);
        boolean isOreDict = false;
        HashMap<String, Map<String, Object>> key = new HashMap<String, Map<String, Object>>();
        Character curKey = null;
        while (i < components.length) {
            Object o = components[i];
            if (o instanceof Character) {
                if (curKey != null) {
                    throw new IllegalArgumentException("Provided two char keys in a row");
                }
                curKey = (Character)o;
            } else {
                if (curKey == null) {
                    throw new IllegalArgumentException("Providing object without a char key");
                }
                if (o instanceof String) {
                    isOreDict = true;
                }
                key.put(Character.toString(curKey.charValue()), RecipeToJson.serializeItem(o));
                curKey = null;
            }
            ++i;
        }
        json.put("key", key);
        json.put("type", isOreDict ? "forge:ore_shaped" : "minecraft:crafting_shaped");
        json.put("result", RecipeToJson.serializeItem(result));
        String suffix = result.func_77973_b().func_77614_k() ? "_" + result.func_77952_i() : "";
        File f = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        while (f.exists()) {
            suffix = suffix + "_alt";
            f = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        }
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addShapelessRecipe(ItemStack result, Object ... components) {
        RecipeToJson.setupDir();
        HashMap<String, Object> json = new HashMap<String, Object>();
        boolean isOreDict = false;
        ArrayList<Map<String, Object>> ingredients = new ArrayList<Map<String, Object>>();
        for (Object o : components) {
            if (o instanceof String) {
                isOreDict = true;
            }
            ingredients.add(RecipeToJson.serializeItem(o));
        }
        json.put("ingredients", ingredients);
        json.put("type", isOreDict ? "forge:ore_shapeless" : "minecraft:crafting_shapeless");
        json.put("result", RecipeToJson.serializeItem(result));
        String suffix = result.func_77973_b().func_77614_k() ? "_" + result.func_77952_i() : "";
        File f = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        while (f.exists()) {
            suffix = suffix + "_alt";
            f = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        }
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Map<String, Object> serializeItem(Object thing) {
        if (thing instanceof Item) {
            return RecipeToJson.serializeItem(new ItemStack((Item)thing));
        }
        if (thing instanceof Block) {
            return RecipeToJson.serializeItem(new ItemStack((Block)thing));
        }
        if (thing instanceof ItemStack) {
            ItemStack stack = (ItemStack)thing;
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("item", stack.func_77973_b().getRegistryName().toString());
            if (stack.func_77973_b().func_77614_k() || stack.func_77952_i() != 0) {
                ret.put("data", stack.func_77952_i());
            }
            if (stack.func_190916_E() > 1) {
                ret.put("count", stack.func_190916_E());
            }
            if (stack.func_77942_o()) {
                ret.put("type", "minecraft:item_nbt");
                ret.put("nbt", stack.func_77978_p().toString());
            }
            return ret;
        }
        if (thing instanceof String) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            USED_OD_NAMES.add((String)thing);
            ret.put("item", "#" + ((String)thing).toUpperCase(Locale.ROOT));
            return ret;
        }
        throw new IllegalArgumentException("Not a block, item, stack, or od name");
    }

    private static void generateConstants() {
        ArrayList json = new ArrayList();
        for (String s : USED_OD_NAMES) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("name", s.toUpperCase(Locale.ROOT));
            entry.put("ingredient", (String)ImmutableMap.of((Object)"type", (Object)"forge:ore_dict", (Object)"ore", (Object)s));
            json.add(entry);
        }
        try (FileWriter w = new FileWriter(new File(RECIPE_DIR, "_constants.json"));){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

