/*
 * Decompiled with CFR 0.152.
 */
package com.mramericanmike.bqt.configuration;

import com.mramericanmike.bqt.configuration.ConfigValues;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    public static Configuration configuration;
    public static final String CATEGORY_GENERAL = "general";

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ConfigurationHandler.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        ConfigValues.enableRecipe = configuration.getBoolean("enableRecipe", CATEGORY_GENERAL, ConfigValues.enableRecipe, "Enables recipe for the Better Questing Item");
        ConfigValues.giveItemOnJoinWorld = configuration.getBoolean("giveItemOnJoinWorld", CATEGORY_GENERAL, ConfigValues.giveItemOnJoinWorld, "Gives the player the Better Questing Item when join world");
        ConfigValues.itemToUse = configuration.getInt("itemToUse", CATEGORY_GENERAL, ConfigValues.itemToUse, 1, 3, "What item you want to use? - 1 = MameBoy / 2 = mPad / 3 = Book");
        ConfigValues.keepTriggererOnDeath = configuration.getBoolean("keepTriggererOnDeath", CATEGORY_GENERAL, ConfigValues.keepTriggererOnDeath, "If true the Better Questing Triggerer will remain in inventory when a player dies");
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("bqt")) {
            ConfigurationHandler.loadConfiguration();
        }
    }
}

