/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.indexer;

import binnie.core.machines.Machine;
import binnie.core.machines.inventory.ComponentInventory;
import binnie.core.machines.inventory.SetList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class ComponentIndexerInventory<T>
extends ComponentInventory
implements IInventory {
    protected int guiRefreshCounter = 0;
    protected List<Integer> sortedInventory;
    private final int indexerSize;
    private final List<ItemStack> indexerInventory = new SetList<ItemStack>();
    @Nullable
    private T sortingMode;
    private boolean needsSorting = true;

    public ComponentIndexerInventory(Machine machine) {
        super(machine);
        this.indexerSize = -1;
        this.sortedInventory = new SetList<Integer>();
    }

    public int func_70302_i_() {
        if (this.indexerSize > 0) {
            return this.indexerSize + 1;
        }
        return this.indexerInventory.size() + 1;
    }

    public ItemStack func_70301_a(int index) {
        if (index >= 0 && index < this.indexerInventory.size()) {
            return this.indexerInventory.get(index);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int amount) {
        ItemStack stackInSlot = this.func_70301_a(index);
        if (!stackInSlot.func_190926_b()) {
            ItemStack returnStack = stackInSlot.func_77946_l();
            this.func_70299_a(index, ItemStack.field_190927_a);
            return returnStack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        ++this.guiRefreshCounter;
    }

    public void func_70299_a(int index, ItemStack itemStack) {
        if (index >= 0 && index < this.indexerInventory.size()) {
            this.indexerInventory.set(index, itemStack);
        } else if (!itemStack.func_190926_b()) {
            this.indexerInventory.add(itemStack);
        }
        this.needsSorting = true;
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    @Nullable
    public T getMode() {
        return this.sortingMode;
    }

    public void setMode(T mode) {
        this.sortingMode = mode;
        this.needsSorting = true;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound2) {
        NBTTagCompound nbttagcompound = super.writeToNBT(nbttagcompound2);
        NBTTagList indexerNBT = new NBTTagList();
        for (ItemStack item : this.indexerInventory) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            item.func_77955_b(itemNBT);
            indexerNBT.func_74742_a((NBTBase)itemNBT);
        }
        nbttagcompound.func_74782_a("indexer", (NBTBase)indexerNBT);
        return nbttagcompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        NBTTagList indexerNBT = nbttagcompound.func_150295_c("indexer", 10);
        this.indexerInventory.clear();
        for (int i = 0; i < indexerNBT.func_74745_c(); ++i) {
            NBTTagCompound itemNBT = indexerNBT.func_150305_b(i);
            this.func_70299_a(i, new ItemStack(itemNBT));
        }
        this.needsSorting = true;
        this.func_70296_d();
    }

    public abstract void Sort();

    public List<ItemStack> getIndexerInventory() {
        return this.indexerInventory;
    }

    @Nullable
    public T getSortingMode() {
        return this.sortingMode;
    }

    public boolean isNeedsSorting() {
        return this.needsSorting;
    }

    public void setNeedsSorting(boolean needsSorting) {
        this.needsSorting = needsSorting;
    }

    public int getGuiRefreshCounter() {
        return this.guiRefreshCounter;
    }

    public List<Integer> getSortedInventory() {
        return this.sortedInventory;
    }
}

