/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.integration.jei.inoculator;

import binnie.genetics.item.GeneticLiquid;
import binnie.genetics.machine.inoculator.InoculatorLogic;
import binnie.genetics.machine.splicer.SplicerLogic;
import java.awt.Color;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class InoculatorRecipeWrapper
implements IRecipeWrapper {
    private static final FluidStack BACTERIA_VECTOR = GeneticLiquid.BacteriaVector.get(15);
    private final ItemStack inputSerum;
    private final ItemStack wildcardTarget;
    private final boolean splicer;
    @Nullable
    private Map<Integer, ? extends IGuiIngredient<ItemStack>> currentIngredients;

    public InoculatorRecipeWrapper(ItemStack inputSerum, ItemStack wildcardTarget) {
        this(inputSerum, wildcardTarget, false);
    }

    protected InoculatorRecipeWrapper(ItemStack inputSerum, ItemStack wildcardTarget, boolean splicer) {
        this.inputSerum = inputSerum;
        this.wildcardTarget = wildcardTarget;
        this.splicer = splicer;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, Arrays.asList(this.inputSerum, this.wildcardTarget));
        ingredients.setOutput(ItemStack.class, (Object)this.wildcardTarget);
        if (!this.splicer) {
            ingredients.setInput(FluidStack.class, (Object)BACTERIA_VECTOR);
        }
    }

    public void setCurrentIngredients(Map<Integer, ? extends IGuiIngredient<ItemStack>> currentIngredients) {
        this.currentIngredients = currentIngredients;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.currentIngredients == null) {
            return;
        }
        ItemStack inputSerum = null;
        ItemStack targetStack = null;
        IGuiIngredient<ItemStack> guiIngredient = this.currentIngredients.get(0);
        if (guiIngredient != null) {
            inputSerum = (ItemStack)guiIngredient.getDisplayedIngredient();
        }
        if ((guiIngredient = this.currentIngredients.get(1)) != null) {
            targetStack = (ItemStack)guiIngredient.getDisplayedIngredient();
        }
        if (inputSerum != null && targetStack != null) {
            int processTicks;
            int power;
            if (this.splicer) {
                int numGenes = SplicerLogic.getGenesToUse(inputSerum, targetStack);
                power = SplicerLogic.getProcessEnergy(numGenes);
                processTicks = SplicerLogic.getProcessLength(numGenes);
            } else {
                power = InoculatorLogic.getProcessBaseEnergy(inputSerum);
                processTicks = InoculatorLogic.getProcessLength(inputSerum);
            }
            NumberFormat decimalFormat = NumberFormat.getIntegerInstance(MinecraftForgeClient.getLocale());
            String powerString = decimalFormat.format(power) + " RF";
            int xPower = 15 + (recipeWidth - minecraft.field_71466_p.func_78256_a(powerString)) / 2;
            minecraft.field_71466_p.func_78276_b(powerString, xPower, 5, Color.gray.getRGB());
            String processTime = DurationFormatUtils.formatDurationWords((long)(processTicks * 1000 / 20), (boolean)true, (boolean)true);
            int xTime = 15 + (recipeWidth - minecraft.field_71466_p.func_78256_a(processTime)) / 2;
            minecraft.field_71466_p.func_78276_b(processTime, xTime, 45, Color.gray.getRGB());
        }
    }

    public ItemStack getInputSerum() {
        return this.inputSerum;
    }

    public ItemStack getWildcardTarget() {
        return this.wildcardTarget;
    }
}

