/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.integration.jei.inoculator;

import binnie.core.Binnie;
import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.genetics.Gene;
import binnie.genetics.genetics.Engineering;
import binnie.genetics.integration.jei.inoculator.InoculatorRecipeWrapper;
import binnie.genetics.integration.jei.inoculator.SplicerRecipeWrapper;
import binnie.genetics.item.ItemSerum;
import binnie.genetics.item.ItemSerumArray;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.genetics.ISpeciesType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class InoculatorRecipeMaker {
    public static List<InoculatorRecipeWrapper> create() {
        ArrayList<InoculatorRecipeWrapper> recipes = new ArrayList<InoculatorRecipeWrapper>();
        for (IBreedingSystem system : Binnie.GENETICS.getActiveSystems()) {
            ISpeciesRoot root = system.getSpeciesRoot();
            IChromosomeType speciesChromosomeType = root.getSpeciesChromosomeType();
            IAllele[] defaultTemplate = root.getDefaultTemplate();
            IIndividual individual = root.templateAsIndividual(defaultTemplate);
            for (ISpeciesType speciesType : system.getActiveTypes()) {
                if (!system.isDNAManipulable(speciesType)) continue;
                ItemStack memberStack = root.getMemberStack(individual, speciesType);
                memberStack.func_77964_b(Short.MAX_VALUE);
                IAllele species = defaultTemplate[speciesChromosomeType.ordinal()];
                ItemStack serum = ItemSerum.create(new Gene(species, speciesChromosomeType, root));
                serum.func_77964_b(0);
                recipes.add(new InoculatorRecipeWrapper(serum, memberStack));
                recipes.add(new SplicerRecipeWrapper(serum, memberStack));
                ItemStack serumArray = ItemSerumArray.create(new Gene(species, speciesChromosomeType, root));
                serumArray.func_77964_b(0);
                for (IChromosomeType chromosomeType : root.getKaryotype()) {
                    if (chromosomeType == speciesChromosomeType) continue;
                    IAllele allele = defaultTemplate[chromosomeType.ordinal()];
                    Engineering.addGene(serumArray, new Gene(allele, chromosomeType, root));
                }
                recipes.add(new InoculatorRecipeWrapper(serumArray, memberStack));
                recipes.add(new SplicerRecipeWrapper(serumArray, memberStack));
            }
        }
        return recipes;
    }
}

