/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.brewery.recipes;

import binnie.extratrees.api.recipes.IBreweryCrafting;
import forestry.api.core.INbtWritable;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class BreweryCrafting
implements INbtWritable,
IBreweryCrafting {
    @Nullable
    private FluidStack inputFluid;
    @Nullable
    private final ItemStack[] inputGrains;
    private final ItemStack ingredient;
    private final ItemStack yeast;

    public BreweryCrafting(@Nullable FluidStack inputFluid, ItemStack ingredient, @Nullable ItemStack[] inputGrains, ItemStack yeast) {
        this.inputFluid = inputFluid;
        this.inputGrains = inputGrains == null ? new ItemStack[3] : inputGrains;
        this.ingredient = ingredient;
        this.yeast = yeast;
    }

    public static BreweryCrafting create(NBTTagCompound nbt) {
        FluidStack inputFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("fluid"));
        ItemStack ingredient = new ItemStack(nbt.func_74775_l("ingr"));
        ItemStack[] inputGrains = new ItemStack[]{new ItemStack(nbt.func_74775_l("in1")), new ItemStack(nbt.func_74775_l("in2")), new ItemStack(nbt.func_74775_l("in3"))};
        ItemStack yeast = new ItemStack(nbt.func_74775_l("yeast"));
        return new BreweryCrafting(inputFluid, ingredient, inputGrains, yeast);
    }

    @Override
    public boolean hasInputGrainsEmpty() {
        return this.inputGrains == null || this.isEmptyStack(this.inputGrains[0]) && this.isEmptyStack(this.inputGrains[1]) && this.isEmptyStack(this.inputGrains[2]);
    }

    private boolean isEmptyStack(ItemStack stack) {
        return stack == null || stack.func_190926_b();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.inputFluid != null) {
            NBTTagCompound fluidTag = new NBTTagCompound();
            this.inputFluid.writeToNBT(fluidTag);
            nbt.func_74782_a("fluid", (NBTBase)fluidTag);
        }
        nbt.func_74782_a("ingr", (NBTBase)this.getNBT(this.ingredient));
        nbt.func_74782_a("in1", (NBTBase)this.getNBT(this.inputGrains[0]));
        nbt.func_74782_a("in2", (NBTBase)this.getNBT(this.inputGrains[1]));
        nbt.func_74782_a("in3", (NBTBase)this.getNBT(this.inputGrains[2]));
        nbt.func_74782_a("yeast", (NBTBase)this.getNBT(this.yeast));
        return nbt;
    }

    private NBTTagCompound getNBT(ItemStack ingr) {
        if (ingr.func_190926_b()) {
            return new NBTTagCompound();
        }
        NBTTagCompound nbt = new NBTTagCompound();
        ingr.func_77955_b(nbt);
        return nbt;
    }

    @Override
    @Nullable
    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    @Override
    @Nullable
    public ItemStack[] getInputGrains() {
        return this.inputGrains;
    }

    @Override
    public ItemStack getIngredient() {
        return this.ingredient;
    }

    @Override
    public ItemStack getYeast() {
        return this.yeast;
    }

    public void setInputFluid(@Nullable FluidStack inputFluid) {
        this.inputFluid = inputFluid;
    }
}

