/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.items;

import binnie.core.util.I18N;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.Tabs;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHops
extends Item
implements IPlantable,
IItemModelRegister {
    private final Block crops;
    private final Block soil;

    public ItemHops(Block crops, Block soil) {
        this.crops = crops;
        this.soil = soil;
        this.func_77655_b("hops");
        this.setRegistryName("hops");
        this.func_77637_a(Tabs.tabArboriculture);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        ItemStack itemstack = player.func_184586_b(hand);
        if (!itemstack.func_190926_b() && facing == EnumFacing.UP && player.func_175151_a(pos, facing, itemstack) && state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, pos, EnumFacing.UP, (IPlantable)this) && worldIn.func_175623_d(pos.func_177984_a())) {
            IBlockState blockState;
            if (!worldIn.func_180501_a(pos = pos.func_177984_a(), blockState = this.crops.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand), 11)) {
                return EnumActionResult.FAIL;
            }
            blockState = worldIn.func_180495_p(pos);
            if (blockState.func_177230_c() == this.crops) {
                blockState.func_177230_c().func_180633_a(worldIn, pos, blockState, (EntityLivingBase)player, itemstack);
            }
            SoundType soundtype = blockState.func_177230_c().getSoundType(blockState, worldIn, pos, (Entity)player);
            worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            itemstack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public String func_77653_i(ItemStack itemStack) {
        return I18N.localise("extratrees.item.hops.name");
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.crops.func_176223_P();
    }
}

