/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.items;

import binnie.core.liquid.AlcoholEffect;
import binnie.core.liquid.DrinkManager;
import binnie.core.liquid.IDrinkLiquid;
import binnie.extratrees.alcohol.GlasswareType;
import binnie.extratrees.alcohol.drink.FluidHandlerItemGlassware;
import binnie.extratrees.liquid.Alcohol;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.Tabs;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDrink
extends ItemFood
implements IItemModelRegister {
    public static final String TYPE_NBT_KEY = "glassware";

    public ItemDrink() {
        super(0, 0.0f, false);
        this.func_77637_a(Tabs.tabArboriculture);
        this.func_77655_b("drink");
        this.setRegistryName("drink");
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77848_i();
    }

    public GlasswareType getGlassware(ItemStack container) {
        NBTTagCompound nbt = container.func_77978_p();
        if (nbt == null || !nbt.func_74764_b(TYPE_NBT_KEY)) {
            return GlasswareType.BEER_MUG;
        }
        return GlasswareType.values()[nbt.func_74765_d(TYPE_NBT_KEY)];
    }

    public ItemStack getStack(GlasswareType glass, @Nullable FluidStack fluid, int amount) {
        ItemStack stack = new ItemStack((Item)this, amount);
        this.saveGlassware(glass, stack);
        this.saveFluid(fluid, stack);
        return stack;
    }

    public ItemStack getStack(GlasswareType glass, @Nullable FluidStack fluid) {
        return this.getStack(glass, fluid, 1);
    }

    public void saveGlassware(GlasswareType container, ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_74777_a(TYPE_NBT_KEY, (short)container.ordinal());
    }

    public void saveFluid(@Nullable FluidStack fluid, ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        if (fluid == null) {
            nbt.func_82580_o("Fluid");
        } else {
            IFluidHandler handler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            handler.fill(fluid, true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (GlasswareType glasswareType : GlasswareType.values()) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{glasswareType.getModelLocation()});
        }
        manager.registerItemModel(item, stack -> {
            GlasswareType glasswareType = this.getGlassware(stack);
            return glasswareType.getModelLocation();
        });
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new FluidHandlerItemGlassware(stack, this.getGlassware(stack));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (GlasswareType glasswareType : GlasswareType.values()) {
                items.add((Object)this.getStack(glasswareType, null));
            }
            items.add((Object)this.getStack(GlasswareType.WINE, Alcohol.RedWine.get(GlasswareType.WINE.getCapacity())));
        }
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
        IDrinkLiquid liquid = fluid == null ? null : DrinkManager.getLiquid(fluid.getFluid());
        String liquidName = liquid == null ? null : liquid.getName();
        return this.getGlassware(stack).getName(liquidName);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        IFluidHandler handler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (handler != null && entityLiving instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            entityplayer.func_71024_bL().func_151686_a((ItemFood)this, stack);
            worldIn.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187664_bz, SoundCategory.PLAYERS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            this.func_77849_c(stack, worldIn, entityplayer);
            entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
            handler.drain(Integer.MAX_VALUE, true);
            if (entityplayer instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)entityplayer, stack);
            }
            return stack;
        }
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        float strength;
        super.func_77849_c(stack, world, player);
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
        IDrinkLiquid liquid = fluid == null ? null : DrinkManager.getLiquid(fluid.getFluid());
        float f = strength = liquid == null ? 0.0f : liquid.getABV();
        if (strength > 0.0f) {
            AlcoholEffect.makeDrunk(player, strength);
        }
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        if (FluidUtil.getFluidContained((ItemStack)itemStack) != null) {
            return EnumAction.DRINK;
        }
        return EnumAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return 16;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        return super.func_77659_a(world, player, hand);
    }
}

