/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.genetics;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IAlleleButterflySpeciesBuilder;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.api.lepidopterology.IButterflyMutationBuilder;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.lepidopterology.genetics.Butterfly;
import forestry.lepidopterology.genetics.ButterflyDefinition;
import forestry.lepidopterology.genetics.IButterflyDefinition;
import forestry.lepidopterology.genetics.MothDefinition;
import java.awt.Color;
import java.util.Arrays;
import net.minecraft.item.ItemStack;

public enum ButterflySpecies implements IButterflyDefinition
{
    White_Admiral("White Admiral", "Limenitis camilla", 0xFAFAFA),
    Purple_Emperor("Purple Emperor", "Apatura iris", 4338374),
    Red_Admiral("Red Admiral", "Vanessa atalanta", 15101764),
    Painted_Lady("Painted Lady", "Vanessa cardui", 15573064),
    Small_Tortoiseshell("Small Tortoiseshell", "Aglais urticae", 15365387),
    Camberwell_Beauty("Camberwell Beauty", "Aglais antiopa", 9806540),
    Peacock("Peacock", "Inachis io", 13842434),
    Wall("Wall", "Lasiommata megera", 15707678),
    Crimson_Rose("Crimson Rose", "Atrophaneura hector", 16736891),
    Kaiser_I_Hind("Kaiser-i-Hind", "Teinopalpus imperialis", 7839808),
    Golden_Birdwing("Golden Birdwing", "Troides aeacus", 16374814),
    Marsh_Fritillary("Marsh Fritillary", "Euphydryas aurinia", 16747520),
    Pearl_Bordered_Fritillary("Pearl-bordered Fritillary", "Boloria euphrosyne", 16747267),
    Queen_Of_Spain_Fritillary("Queen of Spain Fritillary", "Issoria lathonia", 16765247),
    Speckled_Wood("Speckled Wood", "Pararge aegeria", 16119949),
    Scotch_Angus("Scotch Angus", "Erebia aethiops", 12735523),
    Gatekeeper("Gatekeeper", "Pyronia tithonus", 16433962),
    Meadow_Brown("Meadow Brown", "Maniola jurtina", 14914841),
    Small_Heath("Small Heath", "Coenonympha pamphilus", 16754226),
    Ringlet("Ringlet", "Aphantopus hyperantus", 9919799),
    Monarch("Monarch", "Danaus plexippus", 16757254),
    Marbled_White("Marbled White", "Melanargia galathea", 0xECECEC);

    public static final ButterflySpecies[] VALUES;
    private final IAlleleButterflySpecies species;
    private final IClassification branch;
    private IAllele[] template;
    private IButterflyGenome genome;

    private ButterflySpecies(String name, String scientific, int colour) {
        String branchName = scientific.split(" ")[0].toLowerCase();
        String binomial = scientific.split(" ")[1];
        String branchUid = "trees." + branchName.toLowerCase();
        IClassification branch = AlleleManager.alleleRegistry.getClassification("genus." + branchUid);
        if (branch == null) {
            branch = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.GENUS, branchUid, scientific);
        }
        this.branch = branch;
        String uid = "extrabutterflies.species." + this.toString().toLowerCase().replace("_", "");
        String unlocalizedName = uid + ".name";
        IClassification parent = branch.getParent();
        String unlocalizedDescription = "for.description." + uid;
        String texture = "butterflies/" + this.toString().toLowerCase();
        IAlleleButterflySpeciesBuilder speciesBuilder = ButterflyManager.butterflyFactory.createSpecies(uid, unlocalizedName, "Binnie", unlocalizedDescription, "extratrees", texture, true, branch, binomial, new Color(colour));
        speciesBuilder.setRarity(0.5f);
        this.setSpeciesProperties(speciesBuilder);
        this.species = speciesBuilder.build();
    }

    public static void initButterflies() {
        for (ButterflySpecies butterfly : VALUES) {
            butterfly.init();
        }
        for (ButterflySpecies butterfly : VALUES) {
            butterfly.registerMutations();
        }
    }

    public static void preInit() {
    }

    private void init() {
        this.template = ButterflyManager.butterflyRoot.getDefaultTemplate();
        AlleleHelper.getInstance().set(this.template, (Enum)EnumButterflyChromosome.SPECIES, (IAllele)this.species);
        this.setAlleles(this.template);
        this.genome = ButterflyManager.butterflyRoot.templateAsGenome(this.template);
        ButterflyManager.butterflyRoot.registerTemplate(this.template);
    }

    protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
    }

    protected void setAlleles(IAllele[] alleles) {
    }

    protected void registerMutations() {
    }

    protected final IButterflyMutationBuilder registerMutation(IButterflyDefinition parent1, IButterflyDefinition parent2, int chance) {
        IAlleleButterflySpecies species2;
        IAlleleButterflySpecies species1;
        if (parent1 instanceof ButterflySpecies) {
            species1 = ((ButterflySpecies)parent1).species;
        } else if (parent1 instanceof ButterflyDefinition) {
            species1 = ((ButterflyDefinition)parent1).getSpecies();
        } else if (parent1 instanceof MothDefinition) {
            species1 = ((MothDefinition)parent1).getSpecies();
        } else {
            throw new IllegalArgumentException("Unknown parent1: " + parent1);
        }
        if (parent2 instanceof ButterflySpecies) {
            species2 = ((ButterflySpecies)parent2).species;
        } else if (parent2 instanceof ButterflyDefinition) {
            species2 = ((ButterflyDefinition)parent2).getSpecies();
        } else if (parent2 instanceof MothDefinition) {
            species2 = ((MothDefinition)parent2).getSpecies();
        } else {
            throw new IllegalArgumentException("Unknown parent2: " + parent2);
        }
        return ButterflyManager.butterflyMutationFactory.createMutation(species1, species2, this.getTemplate(), chance);
    }

    public final IAllele[] getTemplate() {
        return Arrays.copyOf(this.template, this.template.length);
    }

    public final IButterflyGenome getGenome() {
        return this.genome;
    }

    public final IButterfly getIndividual() {
        return new Butterfly(this.genome);
    }

    public final ItemStack getMemberStack(EnumFlutterType flutterType) {
        IButterfly butterfly = this.getIndividual();
        return ButterflyManager.butterflyRoot.getMemberStack((IIndividual)butterfly, (ISpeciesType)flutterType);
    }

    public IAlleleButterflySpecies getSpecies() {
        return this.species;
    }

    static {
        VALUES = ButterflySpecies.values();
    }
}

