/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gen;

import binnie.extratrees.gen.WorldGenTree;
import forestry.api.arboriculture.ITree;
import forestry.api.world.ITreeGenData;

public class WorldGenTilia {

    public static class CommonLime
    extends WorldGenTree {
        public CommonLime(ITree tree) {
            super((ITreeGenData)tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 1;
            float bottom = this.randBetween(2, 3);
            float width = (float)this.height * this.randBetween(0.45f, 0.55f);
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.3f * width, 1, this.leaf, false);
            float f2 = leafSpawn;
            leafSpawn = f2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), 0.8f * width, 1, this.leaf, false);
            while (leafSpawn > bottom) {
                float f3 = leafSpawn;
                leafSpawn = f3 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f3, 0.0f), this.randBetween(0.95f, 1.05f) * width, 1, this.leaf, false);
            }
            float f4 = leafSpawn;
            leafSpawn = f4 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f4, 0.0f), 0.7f * width, 1, this.leaf, false);
            this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn, 0.0f), 0.4f * width, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(7, 4);
            this.girth = this.determineGirth(this.treeGen.getGirth());
        }
    }

    public static class WhiteBasswood
    extends WorldGenTree {
        public WhiteBasswood(ITree tree) {
            super((ITreeGenData)tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 1;
            float bottom = this.randBetween(2, 3);
            float width = (float)this.height * this.randBetween(0.4f, 0.5f);
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.3f * width, 1, this.leaf, false);
            float f2 = leafSpawn;
            leafSpawn = f2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), 0.8f * width, 1, this.leaf, false);
            while (leafSpawn > bottom) {
                float f3 = leafSpawn;
                leafSpawn = f3 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f3, 0.0f), this.randBetween(0.95f, 1.05f) * width, 1, this.leaf, false);
            }
            float f4 = leafSpawn;
            leafSpawn = f4 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f4, 0.0f), 0.7f * width, 1, this.leaf, false);
            this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn, 0.0f), 0.4f * width, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(6, 3);
            this.girth = this.determineGirth(this.treeGen.getGirth());
        }
    }

    public static class Basswood
    extends WorldGenTree {
        public Basswood(ITree tree) {
            super((ITreeGenData)tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 1;
            float bottom = this.randBetween(2, 3);
            float width = (float)this.height * this.randBetween(0.4f, 0.5f);
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.3f * width, 1, this.leaf, false);
            float f2 = leafSpawn;
            leafSpawn = f2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), 0.8f * width, 1, this.leaf, false);
            while (leafSpawn > bottom) {
                float f3 = leafSpawn;
                leafSpawn = f3 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f3, 0.0f), this.randBetween(0.95f, 1.05f) * width, 1, this.leaf, false);
            }
            float h4 = leafSpawn;
            leafSpawn = h4 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h4, 0.0f), 0.7f * width, 1, this.leaf, false);
            float h5 = leafSpawn;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h5, 0.0f), 0.4f * width, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(6, 3);
            this.girth = this.determineGirth(this.treeGen.getGirth());
        }
    }
}

