/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.machines;

import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.extrabees.machines.ExtraBeeMachines;
import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.DefaultBeeListener;
import forestry.api.apiculture.DefaultBeeModifier;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.api.multiblock.IMultiblockLogicAlveary;
import forestry.api.multiblock.MultiblockManager;
import java.util.Collection;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class TileExtraBeeAlveary
extends TileEntityMachine
implements IAlvearyComponent.Active,
IAlvearyComponent.BeeModifier,
IAlvearyComponent.BeeListener {
    private static final IBeeModifier BLANK_MODIFIER = new DefaultBeeModifier();
    private static final IBeeListener BLANK_LISTENER = new DefaultBeeListener();
    private IMultiblockLogicAlveary structureLogic = MultiblockManager.logicFactory.createAlvearyLogic();

    public TileExtraBeeAlveary() {
    }

    public TileExtraBeeAlveary(ExtraBeeMachines.AlvearyPackage alvearyPackage) {
        super(alvearyPackage);
    }

    public BlockPos getCoordinates() {
        return this.func_174877_v();
    }

    public GameProfile getOwner() {
        return this.getMachine().getOwner();
    }

    public Collection<IMultiblockComponent> getAlvearyBlocks() {
        return this.structureLogic.getController().getComponents();
    }

    public void onMachineAssembled(IMultiblockController multiblockController, BlockPos minCoord, BlockPos maxCoord) {
    }

    public void onMachineBroken() {
    }

    public IMultiblockLogicAlveary getMultiblockLogic() {
        return this.structureLogic;
    }

    public void updateClient(int arg0) {
        super.func_73660_a();
    }

    public void updateServer(int arg0) {
        super.func_73660_a();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.structureLogic.invalidate(this.field_145850_b, (IMultiblockComponent)this);
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.structureLogic.onChunkUnload(this.field_145850_b, (IMultiblockComponent)this);
    }

    public void func_145829_t() {
        this.structureLogic.validate(this.field_145850_b, (IMultiblockComponent)this);
    }

    public IBeeModifier getBeeModifier() {
        Machine machine = this.getMachine();
        if (machine == null) {
            return BLANK_MODIFIER;
        }
        IBeeModifier modifier = machine.getInterface(IBeeModifier.class);
        if (modifier != null) {
            return modifier;
        }
        return BLANK_MODIFIER;
    }

    public IBeeListener getBeeListener() {
        Machine machine = this.getMachine();
        if (machine == null) {
            return BLANK_LISTENER;
        }
        IBeeListener listener = machine.getInterface(IBeeListener.class);
        if (listener != null) {
            return listener;
        }
        return BLANK_LISTENER;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound2) {
        NBTTagCompound nbtTagCompound = super.func_189515_b(nbtTagCompound2);
        NBTTagCompound tag = new NBTTagCompound();
        this.structureLogic.writeToNBT(tag);
        nbtTagCompound.func_74782_a("structureLogic", (NBTBase)tag);
        return nbtTagCompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        NBTTagCompound tag = nbtTagCompound.func_74775_l("structureLogic");
        if (!tag.func_82582_d()) {
            this.structureLogic.readFromNBT(tag);
        }
    }
}

