/*
 * Decompiled with CFR 0.152.
 */
package binnie.design;

import binnie.core.block.TileEntityMetadata;
import binnie.design.Design;
import binnie.design.api.IDesign;
import binnie.design.api.IDesignMaterial;
import binnie.design.api.IDesignSystem;
import binnie.design.blocks.BlockDesign;
import binnie.design.blocks.DesignBlock;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public final class DesignHelper {
    private DesignHelper() {
    }

    public static DesignBlock getDesignBlock(IDesignSystem system, int meta) {
        int plankID1 = meta & 0xFF;
        int plankID2 = meta >> 8 & 0xFF;
        int tile = meta >> 16 & 0x3FF;
        int rotation = meta >> 26 & 3;
        int axis = meta >> 28 & 7;
        IDesignMaterial type1 = system.getMaterial(plankID1);
        IDesignMaterial type2 = system.getMaterial(plankID2);
        IDesign type3 = Design.getDesignManager().getDesign(tile);
        return new DesignBlock(system, type1, type2, type3, rotation, EnumFacing.field_82609_l[axis]);
    }

    public static int getBlockMetadata(IDesignSystem system, DesignBlock block) {
        int plank1 = system.getMaterialIndex(block.getPrimaryMaterial());
        int plank2 = system.getMaterialIndex(block.getSecondaryMaterial());
        int design = Design.getDesignManager().getDesignIndex(block.getDesign());
        int rotation = block.getRotation();
        int facing = block.getFacing().ordinal();
        return DesignHelper.getMetadata(plank1, plank2, design, rotation, facing);
    }

    public static int getItemMetadata(IDesignSystem system, DesignBlock block) {
        int plank1 = system.getMaterialIndex(block.getPrimaryMaterial());
        int plank2 = system.getMaterialIndex(block.getSecondaryMaterial());
        int design = Design.getDesignManager().getDesignIndex(block.getDesign());
        return DesignHelper.getMetadata(plank1, plank2, design, 0, EnumFacing.UP.ordinal());
    }

    public static ItemStack getItemStack(BlockDesign block, IDesignMaterial type1, IDesignMaterial type2, IDesign design) {
        int designIndex = Design.getDesignManager().getDesignIndex(design);
        int materialIndex1 = block.getDesignSystem().getMaterialIndex(type1);
        int materialIndex2 = block.getDesignSystem().getMaterialIndex(type2);
        return DesignHelper.getItemStack(block, materialIndex1, materialIndex2, designIndex);
    }

    public static ItemStack getItemStack(BlockDesign block, int type1, int type2, int design) {
        return TileEntityMetadata.getItemStack((Block)block, DesignHelper.getMetadata(type1, type2, design, 0, EnumFacing.UP.ordinal()));
    }

    public static ItemStack getItemStack(BlockDesign blockC, DesignBlock block) {
        return DesignHelper.getItemStack(blockC, block.getPrimaryMaterial(), block.getSecondaryMaterial(), block.getDesign());
    }

    public static int getMetadata(int plank1, int plank2, int design, int rotation, int facing) {
        return plank1 + (plank2 << 8) + (design << 16) + (rotation << 26) + (facing << 28);
    }

    public static boolean isValidPanelPlacement(IBlockAccess world, BlockPos pos, @Nullable EnumFacing facing) {
        if (facing == null) {
            return false;
        }
        pos = pos.func_177972_a(facing);
        IBlockState state = world.func_180495_p(pos);
        return state.isSideSolid(world, pos, facing.func_176734_d());
    }
}

