/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.fieldkit;

import binnie.core.Binnie;
import binnie.core.api.gui.IPoint;
import binnie.core.api.gui.ITexture;
import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.ITooltip;
import binnie.core.gui.Tooltip;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.events.EventValueChanged;
import binnie.core.gui.events.EventWidget;
import binnie.core.gui.fieldkit.ControlChromosome;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.resource.textures.StandardTexture;
import binnie.core.gui.resource.textures.Texture;
import binnie.core.texture.BinnieCoreTexture;
import forestry.api.genetics.IChromosomeType;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlChromoPicker
extends Control
implements ITooltip {
    private final Texture selected = new StandardTexture(160, 18, 16, 16, BinnieCoreTexture.GUI_PUNNETT);
    private final Texture texture = new StandardTexture(160, 34, 16, 16, BinnieCoreTexture.GUI_PUNNETT);
    private final IChromosomeType type;
    private final ControlChromosome parent;

    public ControlChromoPicker(ControlChromosome parent, int x, int y, IChromosomeType chromo) {
        super(parent, x, y, 16, 16);
        this.type = chromo;
        this.addAttribute(Attribute.MOUSE_OVER);
        this.parent = parent;
        this.addSelfEventHandler(EventWidget.StartMouseOver.class, event -> this.callEvent(new EventValueChanged<IChromosomeType>(this.getWidget(), this.type)));
        this.addSelfEventHandler(EventWidget.EndMouseOver.class, event -> this.callEvent(new EventValueChanged<Object>(this.getWidget(), null)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        super.onRenderBackground(guiWidth, guiHeight);
        boolean selected = this.isMouseOver();
        Texture text = selected ? this.selected : this.texture;
        CraftGUI.RENDER.texture((ITexture)text, (IPoint)Point.ZERO);
    }

    @Override
    public void getTooltip(Tooltip tooltip, ITooltipFlag tooltipFlag) {
        tooltip.add(Binnie.GENETICS.getSystem(this.parent.getRoot()).getChromosomeName(this.type));
    }

    @Override
    @Nullable
    public ControlChromosome getParent() {
        return this.parent;
    }
}

