/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.core.util.I18N;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.core.genetics.alleles.EnumAllele;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.text.WordUtils;

public class AlleleHelper
extends forestry.core.genetics.alleles.AlleleHelper {
    private static final Pattern PATTERN_REPLACEMENT = Pattern.compile("_");

    public static IAllele getAllele(EnumTemperature temperature) {
        return AlleleHelper.getAllele(AlleleHelper.getUid(temperature));
    }

    public static IAllele getAllele(EnumHumidity humidity) {
        return AlleleHelper.getAllele(AlleleHelper.getUid(humidity));
    }

    public static IAllele getAllele(EnumTolerance tolerance) {
        return AlleleHelper.getAllele(AlleleHelper.getUid(tolerance));
    }

    public static IAllele getAllele(EnumAllele.Fertility fertility) {
        return AlleleHelper.getAllele(AlleleHelper.getUid(fertility));
    }

    public static IAllele getAllele(EnumAllele.Territory territory) {
        return AlleleHelper.getAllele(AlleleHelper.getUid(territory));
    }

    public static IAllele getAllele(EnumAllele.Lifespan lifespan) {
        return AlleleHelper.getAllele(AlleleHelper.getUid(lifespan));
    }

    public static IAllele getAllele(EnumAllele.Sappiness sappiness) {
        return AlleleHelper.getAllele(AlleleHelper.getUid(sappiness));
    }

    public static IAllele getAllele(EnumAllele.Speed speed) {
        return AlleleHelper.getAllele(AlleleHelper.getUid(speed));
    }

    public static IAllele getAllele(EnumAllele.Flowering flowering) {
        return AlleleHelper.getAllele(AlleleHelper.getUid(flowering));
    }

    public static IAllele getAllele(EnumAllele.Height height) {
        return AlleleHelper.getAllele(AlleleHelper.getUid(height));
    }

    public static IAllele getAllele(EnumAllele.Maturation maturation) {
        return AlleleHelper.getAllele(AlleleHelper.getUid(maturation));
    }

    public static IAllele getAllele(EnumAllele.Yield yield) {
        return AlleleHelper.getAllele(AlleleHelper.getUid(yield));
    }

    public static IAllele getAllele(EnumAllele.Saplings saplings) {
        return AlleleHelper.getAllele(AlleleHelper.getUid(saplings));
    }

    public static IAllele getAllele(int number) {
        return AlleleHelper.getAllele("forestry.i" + number + 'd');
    }

    public static IAllele getAllele(boolean bool) {
        if (bool) {
            return AlleleHelper.getAllele("forestry.boolTrue");
        }
        return AlleleHelper.getAllele("forestry.boolFalse");
    }

    public static IAllele getAllele(String uid) {
        return AlleleManager.alleleRegistry.getAllele(uid);
    }

    public static String toDisplay(EnumTemperature temperature) {
        return AlleleManager.climateHelper.toDisplay(temperature);
    }

    public static String toDisplay(EnumHumidity humidity) {
        return AlleleManager.climateHelper.toDisplay(humidity);
    }

    public static String toDisplay(EnumTolerance tolerance) {
        return AlleleHelper.toAlleleDisplay("tolerance", tolerance.name());
    }

    public static String toDisplay(EnumAllele.Flowering flowering) {
        if (flowering == EnumAllele.Flowering.AVERAGE) {
            return AlleleHelper.toAlleleDisplay("flowering", "normal");
        }
        return AlleleHelper.toAlleleDisplay(null, flowering.name());
    }

    public static String toDisplay(EnumAllele.Speed speed) {
        return AlleleHelper.toAlleleDisplay(null, speed.name());
    }

    public static String toDisplay(EnumAllele.Lifespan lifespan) {
        return AlleleHelper.toAlleleDisplay("lifespan", lifespan.name());
    }

    public static String getUid(EnumAllele.Fertility fertility) {
        return AlleleHelper.getUid("fertility", fertility.name());
    }

    public static String getUid(EnumAllele.Lifespan lifespan) {
        return AlleleHelper.getUid("lifespan", lifespan.name());
    }

    public static String getUid(EnumAllele.Sappiness sappiness) {
        return AlleleHelper.getUid("sappiness", sappiness.name());
    }

    private static String getUid(EnumTemperature temperature) {
        return AlleleHelper.getUid("temperature", temperature.name());
    }

    private static String getUid(EnumHumidity humidity) {
        return AlleleHelper.getUid("humidity", humidity.name());
    }

    public static String getUid(EnumAllele.Saplings saplings) {
        if (saplings == EnumAllele.Saplings.AVERAGE) {
            return AlleleHelper.getUid("saplings", "Default");
        }
        if (saplings == EnumAllele.Saplings.HIGH) {
            return AlleleHelper.getUid("saplings", "Double");
        }
        if (saplings == EnumAllele.Saplings.HIGHER) {
            return AlleleHelper.getUid("saplings", "Triple");
        }
        return AlleleHelper.getUid("saplings", saplings.name());
    }

    public static String getUid(EnumAllele.Height height) {
        if (height == EnumAllele.Height.AVERAGE) {
            return AlleleHelper.getUid("height", "Max10", false);
        }
        return AlleleHelper.getUid("height", height.name());
    }

    public static String getUid(EnumAllele.Maturation maturation) {
        return AlleleHelper.getUid("maturation", maturation.name());
    }

    public static String getUid(EnumAllele.Territory territory) {
        return AlleleHelper.getUid("territory", territory.name());
    }

    public static String getUid(EnumAllele.Yield yield) {
        if (yield == EnumAllele.Yield.AVERAGE) {
            return AlleleHelper.getUid("yield", "Default", false);
        }
        return AlleleHelper.getUid("yield", yield.name());
    }

    public static String getUid(EnumAllele.Fireproof fireproof) {
        return AlleleHelper.getUid("bool", fireproof.name());
    }

    public static String getUid(EnumAllele.Flowering flowering) {
        return AlleleHelper.getUid("flowering", flowering.name());
    }

    public static String getUid(EnumTolerance tolerance) {
        return AlleleHelper.getUid("tolerance", tolerance.name());
    }

    public static String getUid(EnumAllele.Speed speed) {
        return AlleleHelper.getUid("speed", speed.name());
    }

    protected static String getUid(String key, String valueName) {
        return AlleleHelper.getUid(key, valueName, true);
    }

    private static String getUid(String key, String valueName, boolean needCapitalize) {
        if (needCapitalize) {
            valueName = WordUtils.capitalize((String)valueName.toLowerCase(Locale.ENGLISH));
        }
        valueName = PATTERN_REPLACEMENT.matcher(valueName).replaceAll("");
        return "forestry." + key + valueName;
    }

    private static String toAlleleDisplay(@Nullable String key, String valueName) {
        String name = PATTERN_REPLACEMENT.matcher(valueName.toLowerCase()).replaceAll("");
        if (key == null) {
            return I18N.localise("forestry.allele." + name);
        }
        return I18N.localise("forestry.allele." + key + '.' + name);
    }
}

