/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.network;

import binnie.botany.api.genetics.EnumFlowerColor;
import binnie.botany.api.genetics.IAlleleFlowerSpecies;
import binnie.core.BinnieCore;
import binnie.core.network.IPacketID;
import binnie.core.network.packet.MessageBinnie;
import binnie.core.network.packet.MessageNBT;
import binnie.core.util.I18N;
import forestry.api.genetics.AlleleManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public enum PacketID implements IPacketID
{
    FIELDKIT;


    @Override
    public void onMessage(MessageBinnie message, MessageContext context) {
        if (this == FIELDKIT && context.side == Side.CLIENT) {
            MessageNBT packet = new MessageNBT(message);
            this.onUseFieldKit(packet.getTagCompound());
        }
    }

    public void onUseFieldKit(NBTTagCompound data) {
        EntityPlayer player = BinnieCore.getBinnieProxy().getPlayer();
        String info = "";
        if (data.func_82582_d()) {
            info = info + I18N.localise("botany.flowers.species.not.discover");
        } else {
            IAlleleFlowerSpecies primary = (IAlleleFlowerSpecies)AlleleManager.alleleRegistry.getAllele(data.func_74779_i("Species"));
            IAlleleFlowerSpecies secondary = (IAlleleFlowerSpecies)AlleleManager.alleleRegistry.getAllele(data.func_74779_i("Species2"));
            float age = data.func_74760_g("Age");
            EnumFlowerColor color1 = EnumFlowerColor.get(data.func_74765_d("Colour"));
            EnumFlowerColor color2 = EnumFlowerColor.get(data.func_74765_d("Colour2"));
            if (primary == null || secondary == null) {
                return;
            }
            info = info + I18N.localise("botany.flowers.fielkit.a");
            info = age == 0.0f ? info + "" : (age < 0.25f ? info + ' ' + I18N.localise("botany.flowers.fielkit.young") : (age < 0.75f ? info + ' ' + I18N.localise("botany.flowers.fielkit.mature") : info + ' ' + I18N.localise("botany.flowers.fielkit.old")));
            info = color1 == color2 ? info + ' ' + color1.func_176610_l() : info + ' ' + color1.func_176610_l() + " & " + color2.func_176610_l();
            info = primary == secondary ? info + ' ' + primary.getAlleleName() : info + ' ' + primary.getAlleleName() + '-' + secondary.getAlleleName() + ' ' + I18N.localise("botany.flowers.species.hybrid");
            if (age == 0.0f) {
                info = info + ' ' + I18N.localise("botany.flowers.species.germling");
            }
            if (data.func_74767_n("Wilting")) {
                info = info + ". " + I18N.localise("botany.flowers.species.wilting");
            }
        }
        player.func_146105_b((ITextComponent)new TextComponentString(info), false);
    }
}

