/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.api.gardening;

import binnie.botany.api.gardening.EnumAcidity;
import binnie.botany.api.gardening.EnumFertiliserType;
import binnie.botany.api.gardening.EnumMoisture;
import binnie.botany.api.gardening.EnumSoilType;
import binnie.botany.api.gardening.IBlockSoil;
import binnie.botany.api.genetics.IFlower;
import forestry.api.core.EnumTemperature;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IGardeningManager {
    default public boolean isSoil(Block block) {
        return block instanceof IBlockSoil;
    }

    public boolean isSoil(Item var1);

    public boolean isSoil(ItemStack var1);

    public EnumMoisture getNaturalMoisture(World var1, BlockPos var2);

    public EnumAcidity getNaturalPH(World var1, BlockPos var2);

    public float getBiomeMoisture(World var1, BlockPos var2);

    public float getBiomePH(World var1, BlockPos var2);

    public IBlockState getSoil(EnumSoilType var1, boolean var2, EnumMoisture var3, EnumAcidity var4);

    public void plantSoil(World var1, BlockPos var2, EnumSoilType var3, EnumMoisture var4, EnumAcidity var5);

    public Collection<ItemStack> getFertilisers(EnumFertiliserType var1);

    public Map<EnumFertiliserType, Map<ItemStack, Integer>> getFertilisers();

    public void registerFertiliser(EnumFertiliserType var1, ItemStack var2, int var3);

    public boolean isFertiliser(EnumFertiliserType var1, ItemStack var2);

    public int getFertiliserStrength(ItemStack var1);

    public boolean canTolerate(@Nullable IFlower var1, World var2, BlockPos var3);

    public EnumSoilType getSoilType(World var1, BlockPos var2);

    default public Block getSoilBlock(EnumSoilType type) {
        return this.getSoilBlock(type, false);
    }

    public Block getSoilBlock(EnumSoilType var1, boolean var2);

    public boolean canTolerate(IFlower var1, EnumAcidity var2, EnumMoisture var3, EnumTemperature var4);

    public boolean isWeedkiller(ItemStack var1);

    public boolean addWeedKiller(World var1, BlockPos var2);

    public boolean onFertiliseSoil(ItemStack var1, IBlockSoil var2, World var3, BlockPos var4, EntityPlayer var5);
}

