/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.item.diagram;

import cofh.api.core.IPortableData;
import cofh.api.core.ISecurable;
import cofh.api.item.IPlacementUtilItem;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.item.diagram.ItemDiagram;
import cofh.thermalfoundation.util.helpers.RedprintHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ItemDiagramRedprint
extends ItemDiagram
implements IInitializer,
IPlacementUtilItem {
    public static ItemStack diagramRedprint;

    public ItemDiagramRedprint() {
        this.func_77655_b("redprint");
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        RedprintHelper.addInformation(stack, tooltip);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (stack.func_77978_p() != null) {
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.5f, 0.3f);
                stack.func_77982_d(null);
            }
            return EnumActionResult.SUCCESS;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (!block.hasTileEntity(state)) {
            return EnumActionResult.PASS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ISecurable && !((ISecurable)tile).canPlayerAccess(player)) {
            return EnumActionResult.PASS;
        }
        if (tile instanceof IPortableData) {
            if (ServerHelper.isServerWorld((World)world)) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                    ((IPortableData)tile).writePortableData(player, stack.func_77978_p());
                    if (stack.func_77978_p() == null || stack.func_77978_p().func_82582_d()) {
                        stack.func_77982_d(null);
                    } else {
                        stack.func_77978_p().func_74778_a("Type", ((IPortableData)tile).getDataType());
                        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.5f, 0.7f);
                    }
                } else if (stack.func_77978_p().func_74779_i("Type").equals(((IPortableData)tile).getDataType())) {
                    ((IPortableData)tile).readPortableData(player, stack.func_77978_p());
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187909_gi, SoundCategory.PLAYERS, 0.5f, 0.8f);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public String func_77653_i(ItemStack stack) {
        String baseName = StringHelper.localize((String)(this.func_77667_c(stack) + ".name"));
        baseName = baseName + RedprintHelper.getDisplayName(stack);
        return baseName;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return RedprintHelper.getDisplayName(stack).isEmpty() ? EnumRarity.COMMON : EnumRarity.UNCOMMON;
    }

    public boolean onBlockPlacement(ItemStack stack, World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ISecurable && !((ISecurable)tile).canPlayerAccess(player)) {
            return false;
        }
        if (tile instanceof IPortableData) {
            if (ServerHelper.isServerWorld((World)world)) {
                if (!stack.func_77942_o()) {
                    return false;
                }
                if (stack.func_77978_p().func_74779_i("Type").equals(((IPortableData)tile).getDataType())) {
                    ((IPortableData)tile).readPortableData(player, stack.func_77978_p());
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187909_gi, SoundCategory.PLAYERS, 0.5f, 0.8f);
                }
            }
            return true;
        }
        return false;
    }

    public boolean preInit() {
        ForgeRegistries.ITEMS.register(this.setRegistryName("diagram_redprint"));
        ThermalFoundation.proxy.addIModelRegister(this);
        diagramRedprint = new ItemStack((Item)this);
        return true;
    }

    public boolean initialize() {
        RecipeHelper.addShapelessRecipe((ItemStack)diagramRedprint, (Object[])new Object[]{"paper", "paper", "dustRedstone"});
        return true;
    }
}

