/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.item;

import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.attachments.filter.FilterLogic;
import cofh.thermaldynamics.duct.attachments.servo.ServoBase;
import cofh.thermaldynamics.duct.attachments.servo.ServoFluid;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.item.ItemAttachment;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ItemServo
extends ItemAttachment {
    public static EnumRarity[] rarity = new EnumRarity[]{EnumRarity.COMMON, EnumRarity.COMMON, EnumRarity.UNCOMMON, EnumRarity.UNCOMMON, EnumRarity.RARE};
    public static ItemStack servoBasic;
    public static ItemStack servoHardened;
    public static ItemStack servoReinforced;
    public static ItemStack servoSignalum;
    public static ItemStack servoResonant;

    public ItemServo() {
        this.func_77655_b("thermaldynamics.servo");
    }

    public String func_77667_c(ItemStack item) {
        return super.func_77667_c(item) + "." + item.func_77952_i();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < 5; ++i) {
                items.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return rarity[stack.func_77952_i() % 5];
    }

    @Override
    public Attachment getAttachment(EnumFacing side, ItemStack stack, TileGrid tile) {
        int type = stack.func_77952_i() % 5;
        if (tile.getDuct(DuctToken.FLUID) != null) {
            return new ServoFluid(tile, (byte)(side.ordinal() ^ 1), type);
        }
        if (tile.getDuct(DuctToken.ITEMS) != null) {
            return new ServoItem(tile, (byte)(side.ordinal() ^ 1), type);
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int type = stack.func_77952_i() % 5;
        if (!StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.getInfoText((String)"item.thermaldynamics.servo.info"));
            if (StringHelper.displayShiftForDetail) {
                tooltip.add(StringHelper.shiftForDetails());
            }
            return;
        }
        if (ServoBase.canAlterRS(type)) {
            tooltip.add(StringHelper.localize((String)"info.thermaldynamics.servo.redstoneInt"));
        } else {
            tooltip.add(StringHelper.localize((String)"info.thermaldynamics.servo.redstoneExt"));
        }
        tooltip.add("\u00a7e" + StringHelper.localize((String)"info.cofh.items") + "\u00a7r");
        tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.extractRate") + ": " + "\u00a7f" + (ServoItem.tickDelays[type] % 20 == 0 ? Integer.toString(ServoItem.tickDelays[type] / 20) : Float.toString((float)ServoItem.tickDelays[type] / 20.0f)) + "s" + "\u00a7r");
        tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.maxStackSize") + ": " + "\u00a7f" + ServoItem.maxSize[type] + "\u00a7r");
        ItemServo.addFiltering(tooltip, type, Duct.Type.ITEM);
        if (ServoItem.multiStack[type]) {
            tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.slotMulti"));
        } else {
            tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.slotSingle"));
        }
        if (ServoItem.speedBoost[type] != 1) {
            tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.speedBoost") + ": " + "\u00a7f" + ServoItem.speedBoost[type] + "x " + "\u00a7r");
        }
        tooltip.add("\u00a7e" + StringHelper.localize((String)"info.cofh.fluids") + "\u00a7r");
        tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.extractRate") + ": " + "\u00a7f" + Integer.toString((int)(ServoFluid.throttle[type] * 100.0f)) + "%" + "\u00a7r");
        ItemServo.addFiltering(tooltip, type, Duct.Type.FLUID);
    }

    public static void addFiltering(List<String> list, int type, Duct.Type duct) {
        StringBuilder b = new StringBuilder();
        b.append(StringHelper.localize((String)"info.thermaldynamics.filter.options")).append(": ").append("\u00a7f");
        boolean flag = false;
        for (int i = 0; i < FilterLogic.flagTypes.length; ++i) {
            if (!FilterLogic.canAlterFlag(duct, type, i)) continue;
            if (flag) {
                b.append(", ");
            } else {
                flag = true;
            }
            b.append(StringHelper.localize((String)("info.thermaldynamics.filter." + FilterLogic.flagTypes[i])));
        }
        flag = false;
        for (String s : Minecraft.func_71410_x().field_71466_p.func_78271_c(b.toString(), 140)) {
            if (flag) {
                s = "  \u00a7f" + s;
            }
            flag = true;
            list.add("  " + s + "\u00a7r");
        }
    }

    public boolean preInit() {
        ForgeRegistries.ITEMS.register(this.setRegistryName("servo"));
        ThermalDynamics.proxy.addIModelRegister(this);
        servoBasic = new ItemStack((Item)this, 1, 0);
        servoHardened = new ItemStack((Item)this, 1, 1);
        servoReinforced = new ItemStack((Item)this, 1, 2);
        servoSignalum = new ItemStack((Item)this, 1, 3);
        servoResonant = new ItemStack((Item)this, 1, 4);
        ServoBase.initialize();
        return true;
    }

    @Override
    public boolean initialize() {
        RecipeHelper.addShapedRecipe((ItemStack)servoBasic, (Object[])new Object[]{"iGi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('G'), "blockGlass", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone"});
        RecipeHelper.addShapedRecipe((ItemStack)servoHardened, (Object[])new Object[]{"iGi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('G'), "blockGlass", Character.valueOf('I'), "ingotInvar", Character.valueOf('R'), "dustRedstone"});
        RecipeHelper.addShapelessRecipe((ItemStack)servoHardened, (Object[])new Object[]{servoBasic, "ingotInvar"});
        RecipeHelper.addShapedRecipe((ItemStack)servoReinforced, (Object[])new Object[]{"iGi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('G'), "blockGlass", Character.valueOf('I'), "ingotElectrum", Character.valueOf('R'), "dustRedstone"});
        RecipeHelper.addShapelessRecipe((ItemStack)servoReinforced, (Object[])new Object[]{servoBasic, "ingotElectrum"});
        RecipeHelper.addShapelessRecipe((ItemStack)servoReinforced, (Object[])new Object[]{servoHardened, "ingotElectrum"});
        RecipeHelper.addShapedRecipe((ItemStack)servoSignalum, (Object[])new Object[]{"iGi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('G'), "blockGlass", Character.valueOf('I'), "ingotSignalum", Character.valueOf('R'), "dustRedstone"});
        RecipeHelper.addShapelessRecipe((ItemStack)servoSignalum, (Object[])new Object[]{servoBasic, "ingotSignalum"});
        RecipeHelper.addShapelessRecipe((ItemStack)servoSignalum, (Object[])new Object[]{servoHardened, "ingotSignalum"});
        RecipeHelper.addShapelessRecipe((ItemStack)servoSignalum, (Object[])new Object[]{servoReinforced, "ingotSignalum"});
        RecipeHelper.addShapedRecipe((ItemStack)servoResonant, (Object[])new Object[]{"iGi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('G'), "blockGlass", Character.valueOf('I'), "ingotEnderium", Character.valueOf('R'), "dustRedstone"});
        RecipeHelper.addShapelessRecipe((ItemStack)servoResonant, (Object[])new Object[]{servoBasic, "ingotEnderium"});
        RecipeHelper.addShapelessRecipe((ItemStack)servoResonant, (Object[])new Object[]{servoHardened, "ingotEnderium"});
        RecipeHelper.addShapelessRecipe((ItemStack)servoResonant, (Object[])new Object[]{servoReinforced, "ingotEnderium"});
        RecipeHelper.addShapelessRecipe((ItemStack)servoResonant, (Object[])new Object[]{servoSignalum, "ingotEnderium"});
        return true;
    }

    @Override
    public void registerModels() {
        String[] names = new String[]{"basic", "hardened", "reinforced", "signalum", "resonant"};
        for (int i = 0; i < names.length; ++i) {
            ModelResourceLocation location = new ModelResourceLocation("thermaldynamics:attachment", "type=" + this.getRegistryName().func_110623_a() + "_" + names[i]);
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)location);
        }
    }
}

