/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.io.json.config.property.properties;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropBase;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropParserBase;
import java.util.List;
import javax.annotation.Nonnull;
import scala.actors.threadpool.Arrays;

public final class PropChar
extends PropBase<Character> {
    public static final PropCharParser PARSER = new PropCharParser();
    protected List<Character> valid = Lists.newArrayList();

    public PropChar(char value, Character ... validChars) {
        super(Character.valueOf(value));
        if (this.valid != null && validChars.length > 0) {
            this.valid.addAll(Arrays.asList((Object[])validChars));
        }
    }

    @Override
    protected Character validateData(Character data) {
        if (this.valid == null) {
            return data;
        }
        for (char ch : this.valid) {
            if (data.charValue() != ch) continue;
            return data;
        }
        if (this.dataDefault != null) {
            return (Character)this.dataDefault;
        }
        return this.valid.get(0);
    }

    @Override
    public String getExtra() {
        if (this.valid.size() > 0) {
            String values = "";
            int validSize = this.valid.size();
            for (int i = 0; i < validSize; ++i) {
                values = i < validSize - 1 ? values + this.valid.get(i) + "," : values + this.valid.get(i);
            }
            return "[" + values + "]";
        }
        return "";
    }

    @Override
    public PropParserBase getParser() {
        return PARSER;
    }

    protected static class PropCharParser
    extends PropParserBase<PropChar> {
        public PropCharParser() {
            super("ch");
        }

        @Override
        public PropChar fromJson(@Nonnull JsonElement json) throws Exception {
            return new PropChar(json.getAsCharacter(), new Character[0]);
        }

        @Override
        public JsonElement toJson(@Nonnull PropChar prop) throws Exception {
            return new JsonPrimitive((Character)prop.getValue());
        }
    }
}

