/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.io.json.config;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.valkyrieofnight.vlib.core.io.json.IJsonSerializer;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropBase;
import com.valkyrieofnight.vlib.core.io.json.config.property.properties.PropMap;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonConfig
extends PropMap {
    private static Gson gson = new GsonBuilder().registerTypeAdapter(JsonConfig.class, (Object)new JsonConfigParser()).setPrettyPrinting().create();
    private String rawLocationJson;
    private String rawLocationDocumentation;
    private File locationJson;
    private File locationDocumentation;

    public JsonConfig(String location) {
        this.rawLocationJson = location;
        if (!this.rawLocationJson.endsWith(".json")) {
            this.rawLocationDocumentation = this.rawLocationDocumentation + ".txt";
            this.rawLocationJson = this.rawLocationJson + ".json";
        } else {
            this.rawLocationDocumentation = StringUtils.removeEnd(this.rawLocationJson, ".json");
            this.rawLocationDocumentation = this.rawLocationDocumentation + ".txt";
        }
        this.locationJson = new File(this.rawLocationJson);
        this.locationDocumentation = new File(this.rawLocationDocumentation);
    }

    public List<String> dumpData() {
        ArrayList sl = Lists.newArrayList();
        for (String key : ((Map)this.data).keySet()) {
            sl.add(key + ": " + ((PropBase)((Map)this.data).get(key)).getValue());
        }
        return sl;
    }

    public void loadConfig() {
        this.data = new HashMap();
        PropMap map = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.locationJson));
            if (reader.ready()) {
                map = (PropMap)gson.fromJson((Reader)reader, JsonConfig.class);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (map == null) {
            return;
        }
        this.putAll(map);
    }

    public void saveConfig() {
        try {
            this.locationJson.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(this.locationJson);
            writer.write(gson.toJson((Object)this));
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveDocumentation() {
        try {
            this.locationDocumentation.getParentFile().mkdirs();
            OutputStreamWriter outstream = new OutputStreamWriter((OutputStream)new FileOutputStream(this.locationDocumentation), "UTF-16");
            BufferedWriter br = new BufferedWriter(outstream);
            List<String> data = this.getParser().getLocalizedDocumentation(this);
            for (String str : data) {
                br.write(str);
                br.write("\r\n");
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class JsonConfigParser
    extends PropMap.PropMapParser
    implements IJsonSerializer<JsonConfig> {
        public JsonElement serialize(JsonConfig src, Type typeOfSrc, JsonSerializationContext context) {
            try {
                return this.toJson(src);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public JsonConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return (JsonConfig)this.fromJson(json);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

