/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.multiblock;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class IntPos {
    private final int pos;

    public IntPos(int pos) {
        this.pos = pos;
    }

    public IntPos(BlockPos pos) {
        this.pos = IntPos.toInt(pos);
    }

    public int getPos() {
        return this.pos;
    }

    public int[] getSidePositions() {
        return new int[]{this.posDown(), this.posUp(), this.posEast(), this.posWest(), this.posSouth(), this.posNorth()};
    }

    public boolean isBorder() {
        return this.getX() == 0 || this.getX() == 15 || this.getZ() == 0 || this.getZ() == 15;
    }

    public boolean isBorder(EnumFacing facing) {
        switch (facing) {
            case DOWN: 
            case UP: {
                return false;
            }
            case NORTH: {
                return this.getZ() == 0;
            }
            case SOUTH: {
                return this.getZ() == 15;
            }
            case WEST: {
                return this.getX() == 0;
            }
            case EAST: {
                return this.getX() == 15;
            }
        }
        return false;
    }

    public IntPos otherSide(EnumFacing facing) {
        switch (facing) {
            case DOWN: 
            case UP: {
                return this;
            }
            case NORTH: {
                return new IntPos(this.pos + 61440);
            }
            case SOUTH: {
                return new IntPos(this.pos - 61440);
            }
            case WEST: {
                return new IntPos(this.pos + 15);
            }
            case EAST: {
                return new IntPos(this.pos - 15);
            }
        }
        return this;
    }

    public int getX() {
        return this.pos & 0xF;
    }

    public int getY() {
        return this.pos >> 4 & 0xFF;
    }

    public int getZ() {
        return this.pos >> 12 & 0xF;
    }

    public int posSouth() {
        if (this.getZ() >= 15) {
            return -1;
        }
        return this.pos + 4096;
    }

    public int posNorth() {
        if (this.getZ() < 1) {
            return -1;
        }
        return this.pos - 4096;
    }

    public int posEast() {
        if (this.getX() >= 15) {
            return -1;
        }
        return this.pos + 1;
    }

    public int posWest() {
        if (this.getX() < 1) {
            return -1;
        }
        return this.pos - 1;
    }

    public int posUp() {
        if (this.getY() >= 255) {
            return -1;
        }
        return this.pos + 16;
    }

    public int posDown() {
        if (this.getY() < 1) {
            return -1;
        }
        return this.pos - 16;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntPos intPos = (IntPos)o;
        return this.pos == intPos.pos;
    }

    public int hashCode() {
        return this.pos;
    }

    private static int toInt(BlockPos pos) {
        int dx = pos.func_177958_n() & 0xF;
        int dy = pos.func_177956_o();
        int dz = pos.func_177952_p() & 0xF;
        return dz << 12 | dy << 4 | dx;
    }

    public BlockPos toBlockPos(ChunkPos cpos) {
        int dx = this.getX();
        int dy = this.getY();
        int dz = this.getZ();
        return cpos.func_180331_a(dx, dy, dz);
    }
}

