/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.logic;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.ItemStackTools;
import mcjty.xnet.api.gui.IEditorGui;
import mcjty.xnet.api.gui.IndicatorIcon;
import mcjty.xnet.api.helper.AbstractConnectorSettings;
import mcjty.xnet.apiimpl.EnumStringTranslators;
import mcjty.xnet.apiimpl.logic.Sensor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class LogicConnectorSettings
extends AbstractConnectorSettings {
    public static final ResourceLocation iconGuiElements = new ResourceLocation("xnet", "textures/gui/guielements.png");
    public static final String TAG_MODE = "mode";
    public static final String TAG_SPEED = "speed";
    public static final String TAG_REDSTONE_OUT = "rsout";
    public static final int SENSORS = 4;
    private LogicMode logicMode = LogicMode.SENSOR;
    private List<Sensor> sensors = new ArrayList<Sensor>(4);
    private int colors;
    private int speed = 2;
    private Integer redstoneOut;
    private static Set<String> TAGS = ImmutableSet.of((Object)"rsout", (Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object[])new String[]{"color3"});

    public LogicConnectorSettings(@Nonnull EnumFacing side) {
        super(side);
        for (int i = 0; i < 4; ++i) {
            this.sensors.add(new Sensor(i));
        }
    }

    public List<Sensor> getSensors() {
        return this.sensors;
    }

    public void setColorMask(int colors) {
        this.colors = colors;
    }

    public int getColorMask() {
        return this.colors;
    }

    public Integer getRedstoneOut() {
        return this.redstoneOut;
    }

    @Override
    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        switch (this.logicMode) {
            case SENSOR: {
                return new IndicatorIcon(iconGuiElements, 26, 70, 13, 10);
            }
            case OUTPUT: {
                return new IndicatorIcon(iconGuiElements, 39, 70, 13, 10);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getIndicator() {
        return null;
    }

    @Override
    public boolean isEnabled(String tag) {
        if (tag.equals("facing")) {
            return this.advanced && this.logicMode != LogicMode.OUTPUT;
        }
        if (tag.equals(TAG_SPEED)) {
            return true;
        }
        for (Sensor sensor : this.sensors) {
            if (!sensor.isEnabled(tag)) continue;
            return true;
        }
        return TAGS.contains(tag);
    }

    public int getSpeed() {
        return this.speed;
    }

    public LogicMode getLogicMode() {
        return this.logicMode;
    }

    @Override
    public void createGui(IEditorGui gui) {
        this.advanced = gui.isAdvanced();
        String[] speeds = this.advanced ? new String[]{"5", "10", "20", "60", "100", "200"} : new String[]{"10", "20", "60", "100", "200"};
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl().choices(TAG_MODE, "Sensor or Output mode", this.logicMode, LogicMode.values()).choices(TAG_SPEED, this.logicMode == LogicMode.SENSOR ? "Number of ticks for each check" : "Number of ticks for each operation", Integer.toString(this.speed * 5), speeds).nl();
        if (this.logicMode == LogicMode.SENSOR) {
            for (Sensor sensor : this.sensors) {
                sensor.createGui(gui);
            }
        } else {
            gui.label("Redstone:").integer(TAG_REDSTONE_OUT, "Redstone output value", this.redstoneOut, 40, 16).nl();
        }
    }

    @Override
    public void update(Map<String, Object> data) {
        super.update(data);
        this.logicMode = LogicMode.valueOf(((String)data.get(TAG_MODE)).toUpperCase());
        String facing = (String)data.get("facing");
        this.speed = Integer.parseInt((String)data.get(TAG_SPEED)) / 5;
        if (this.speed == 0) {
            this.speed = 2;
        }
        if (this.logicMode == LogicMode.SENSOR) {
            for (Sensor sensor : this.sensors) {
                sensor.update(data);
            }
        } else {
            this.redstoneOut = (Integer)data.get(TAG_REDSTONE_OUT);
        }
    }

    @Override
    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        super.writeToJsonInternal(object);
        LogicConnectorSettings.setEnumSafe(object, "logicmode", this.logicMode);
        LogicConnectorSettings.setIntegerSafe(object, TAG_SPEED, this.speed);
        JsonArray sensorArray = new JsonArray();
        for (Sensor sensor : this.sensors) {
            JsonObject o = new JsonObject();
            LogicConnectorSettings.setEnumSafe(o, "sensormode", sensor.getSensorMode());
            LogicConnectorSettings.setEnumSafe(o, "outputcolor", sensor.getOutputColor());
            LogicConnectorSettings.setEnumSafe(o, "operator", sensor.getOperator());
            LogicConnectorSettings.setIntegerSafe(o, "amount", sensor.getAmount());
            if (!sensor.getFilter().func_190926_b()) {
                o.add("filter", (JsonElement)ItemStackTools.itemStackToJson((ItemStack)sensor.getFilter()));
            }
            sensorArray.add((JsonElement)o);
        }
        object.add("sensors", (JsonElement)sensorArray);
        if (this.speed == 1) {
            object.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        return object;
    }

    @Override
    public void readFromJson(JsonObject object) {
        super.readFromJsonInternal(object);
        this.logicMode = LogicConnectorSettings.getEnumSafe(object, "logicmode", EnumStringTranslators::getLogicMode);
        this.speed = LogicConnectorSettings.getIntegerNotNull(object, TAG_SPEED);
        JsonArray sensorArray = object.get("sensors").getAsJsonArray();
        this.sensors.clear();
        for (JsonElement oe : sensorArray) {
            JsonObject o = oe.getAsJsonObject();
            Sensor sensor = new Sensor(this.sensors.size());
            sensor.setAmount(LogicConnectorSettings.getIntegerNotNull(o, "amount"));
            sensor.setOperator(LogicConnectorSettings.getEnumSafe(o, "operator", EnumStringTranslators::getOperator));
            sensor.setOutputColor(LogicConnectorSettings.getEnumSafe(o, "outputcolor", EnumStringTranslators::getColor));
            sensor.setSensorMode(LogicConnectorSettings.getEnumSafe(o, "sensormode", EnumStringTranslators::getSensorMode));
            if (o.has("filter")) {
                sensor.setFilter(ItemStackTools.jsonToItemStack((JsonObject)o.get("filter").getAsJsonObject()));
            } else {
                sensor.setFilter(ItemStack.field_190927_a);
            }
            this.sensors.add(sensor);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.logicMode = LogicMode.values()[tag.func_74771_c("logicMode")];
        this.speed = tag.func_74762_e(TAG_SPEED);
        if (this.speed == 0) {
            this.speed = 2;
        }
        this.colors = tag.func_74762_e("colors");
        for (Sensor sensor : this.sensors) {
            sensor.readFromNBT(tag);
        }
        this.redstoneOut = tag.func_74762_e(TAG_REDSTONE_OUT);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74774_a("logicMode", (byte)this.logicMode.ordinal());
        tag.func_74768_a(TAG_SPEED, this.speed);
        tag.func_74768_a("colors", this.colors);
        for (Sensor sensor : this.sensors) {
            sensor.writeToNBT(tag);
        }
        if (this.redstoneOut != null) {
            tag.func_74768_a(TAG_REDSTONE_OUT, this.redstoneOut.intValue());
        }
    }

    public static enum LogicMode {
        SENSOR,
        OUTPUT;

    }
}

