/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.items;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.ResourceLocation;
import net.ndrei.teslacorelib.items.BaseAddon;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0000H\u0004J\u001e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0010J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\b\u001a\u00020\u00038TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lnet/ndrei/teslacorelib/items/BaseTieredAddon;", "Lnet/ndrei/teslacorelib/items/BaseAddon;", "modId", "", "tab", "Lnet/minecraft/creativetab/CreativeTabs;", "registryName", "(Ljava/lang/String;Lnet/minecraft/creativetab/CreativeTabs;Ljava/lang/String;)V", "addonFunction", "getAddonFunction", "()Ljava/lang/String;", "tier", "", "getTier", "()I", "canBeAddedTo", "", "machine", "Lnet/ndrei/teslacorelib/tileentities/SidedTileEntity;", "hasSameFunction", "other", "isTierValid", "ignoreSameTier", "isValid", "tesla-core-lib"})
public class BaseTieredAddon
extends BaseAddon {
    protected final boolean hasSameFunction(@Nullable BaseTieredAddon other) {
        return other != null && (this.getClass().isAssignableFrom(other.getClass()) || Intrinsics.areEqual((Object)this.getAddonFunction(), (Object)other.getAddonFunction()));
    }

    @NotNull
    protected String getAddonFunction() {
        ResourceLocation resourceLocation = this.getRegistryName();
        if (resourceLocation == null) {
            Intrinsics.throwNpe();
        }
        String string = resourceLocation.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.registryName!!.toString()");
        return string;
    }

    protected int getTier() {
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isTierValid(@NotNull SidedTileEntity machine, int tier, boolean ignoreSameTier) {
        int element$iv;
        int it;
        int n;
        Iterable iterable;
        Intrinsics.checkParameterIsNotNull((Object)machine, (String)"machine");
        if (tier == 1 && ignoreSameTier) {
            return true;
        }
        HashMap<Integer, BaseAddon> tiers = new HashMap<Integer, BaseAddon>();
        List<BaseAddon> addons = machine.getAddons();
        for (BaseAddon baseAddon : addons) {
            BaseAddon tiered;
            if (!(baseAddon instanceof BaseTieredAddon) || !this.hasSameFunction((BaseTieredAddon)(tiered = baseAddon))) continue;
            if (((BaseTieredAddon)tiered).getTier() == tier && !ignoreSameTier) {
                return false;
            }
            tiers.put(((BaseTieredAddon)tiered).getTier(), tiered);
        }
        if (tier == 1) {
            Map map = tiers;
            if (map.size() == 0) return true;
        }
        if ((iterable = (Iterable)new IntRange(n = 1, tier - 1)) instanceof Collection && ((Collection)iterable).isEmpty()) {
            return false;
        }
        Iterator<BaseAddon> iterator = iterable.iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (!tiers.containsKey(it = (element$iv = ((IntIterator)iterator).nextInt())));
        return true;
    }

    @Override
    public boolean canBeAddedTo(@NotNull SidedTileEntity machine) {
        Intrinsics.checkParameterIsNotNull((Object)machine, (String)"machine");
        return this.isTierValid(machine, this.getTier(), false);
    }

    @Override
    public boolean isValid(@NotNull SidedTileEntity machine) {
        Intrinsics.checkParameterIsNotNull((Object)machine, (String)"machine");
        return super.isValid(machine) && this.isTierValid(machine, this.getTier(), true);
    }

    public BaseTieredAddon(@NotNull String modId, @NotNull CreativeTabs tab, @NotNull String registryName) {
        Intrinsics.checkParameterIsNotNull((Object)modId, (String)"modId");
        Intrinsics.checkParameterIsNotNull((Object)tab, (String)"tab");
        Intrinsics.checkParameterIsNotNull((Object)registryName, (String)"registryName");
        super(modId, tab, registryName);
    }
}

