/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.oredict;

import cofh.core.util.ItemWrapper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.oredict.OreDictionaryArbiterProxy;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryArbiter {
    private static BiMap<String, Integer> oreIDs = HashBiMap.create((int)32);
    private static Map<Integer, ArrayList<ItemStack>> oreStacks = new Object2ObjectOpenHashMap(128);
    private static Map<ItemWrapper, ArrayList<Integer>> stackIDs = new Object2ObjectOpenHashMap(128);
    private static Map<ItemWrapper, ArrayList<String>> stackNames = new Object2ObjectOpenHashMap(128);
    private static String[] oreNames = new String[0];
    public static final String UNKNOWN = "Unknown";
    public static final int UNKNOWN_ID = -1;
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;

    public static void initialize() {
        oreIDs = HashBiMap.create((int)oreIDs.size());
        oreStacks = new Object2ObjectOpenHashMap(oreStacks.size());
        stackIDs = new Object2ObjectOpenHashMap(stackIDs.size());
        stackNames = new Object2ObjectOpenHashMap(stackNames.size());
        oreNames = OreDictionary.getOreNames();
        for (String name : oreNames) {
            NonNullList ores = OreDictionary.getOres((String)name, (boolean)false);
            for (ItemStack ore : ores) {
                OreDictionaryArbiter.registerOreDictionaryEntry(ore, name);
            }
        }
        for (ItemWrapper wrapper : stackIDs.keySet()) {
            ItemWrapper wildItem;
            if (wrapper.metadata == Short.MAX_VALUE || !stackIDs.containsKey(wildItem = new ItemWrapper(wrapper.item, Short.MAX_VALUE))) continue;
            stackIDs.get(wrapper).addAll((Collection<Integer>)stackIDs.get(wildItem));
            stackNames.get(wrapper).addAll((Collection<String>)stackNames.get(wildItem));
        }
        ItemHelper.oreProxy = new OreDictionaryArbiterProxy();
    }

    public static void refresh() {
        OreDictionaryArbiter.initialize();
    }

    public static void registerOreDictionaryEntry(ItemStack stack, String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return;
        }
        int id = OreDictionary.getOreID((String)name);
        oreIDs.put((Object)name, (Object)id);
        if (!oreStacks.containsKey(id)) {
            oreStacks.put(id, new ArrayList());
        }
        oreStacks.get(id).add(stack);
        ItemWrapper item = ItemWrapper.fromItemStack(stack);
        if (!stackIDs.containsKey(item)) {
            stackIDs.put(item, new ArrayList());
            stackNames.put(item, new ArrayList());
        }
        stackIDs.get(item).add(id);
        stackNames.get(item).add(name);
    }

    public static int getOreID(String name) {
        Integer id = (Integer)oreIDs.get((Object)name);
        return id == null ? -1 : id;
    }

    public static int getOreID(ItemStack stack) {
        if (stack.func_190926_b()) {
            return -1;
        }
        ArrayList<Integer> ids = stackIDs.get(new ItemWrapper(stack));
        if (ids == null) {
            ids = stackIDs.get(new ItemWrapper(stack.func_77973_b(), Short.MAX_VALUE));
        }
        return ids == null ? -1 : ids.get(0);
    }

    public static List<Integer> getAllOreIDs(ItemStack stack) {
        List ids = stackIDs.get(new ItemWrapper(stack));
        if (ids == null) {
            ids = stackIDs.get(new ItemWrapper(stack.func_77973_b(), Short.MAX_VALUE));
        }
        if (ids == null) {
            ids = new ArrayList();
        }
        return ids;
    }

    public static String getOreName(int id) {
        String oreName = (String)oreIDs.inverse().get((Object)id);
        return oreName == null ? UNKNOWN : oreName;
    }

    public static String getOreName(ItemStack stack) {
        int id = OreDictionaryArbiter.getOreID(stack);
        return id == -1 ? UNKNOWN : OreDictionaryArbiter.getOreName(id);
    }

    public static ArrayList<String> getAllOreNames(ItemStack stack) {
        ArrayList<String> names = stackNames.get(new ItemWrapper(stack));
        if (names == null) {
            names = stackNames.get(new ItemWrapper(stack.func_77973_b(), Short.MAX_VALUE));
        }
        if (names == null) {
            names = new ArrayList();
        }
        return names;
    }

    public static ArrayList<ItemStack> getOres(ItemStack stack) {
        return oreStacks.get(OreDictionaryArbiter.getOreID(stack));
    }

    public static ArrayList<ItemStack> getOres(String name) {
        return oreStacks.get(OreDictionaryArbiter.getOreID(name));
    }

    public static String[] getOreNames() {
        return oreNames;
    }

    private OreDictionaryArbiter() {
        throw new IllegalArgumentException();
    }
}

