/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;

public final class StringHelper {
    public static final String[] ROMAN_NUMERAL = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
    public static final String BLACK = "\u00a70";
    public static final String BLUE = "\u00a71";
    public static final String GREEN = "\u00a72";
    public static final String TEAL = "\u00a73";
    public static final String RED = "\u00a74";
    public static final String PURPLE = "\u00a75";
    public static final String ORANGE = "\u00a76";
    public static final String LIGHT_GRAY = "\u00a77";
    public static final String GRAY = "\u00a78";
    public static final String LIGHT_BLUE = "\u00a79";
    public static final String BRIGHT_GREEN = "\u00a7a";
    public static final String BRIGHT_BLUE = "\u00a7b";
    public static final String LIGHT_RED = "\u00a7c";
    public static final String PINK = "\u00a7d";
    public static final String YELLOW = "\u00a7e";
    public static final String WHITE = "\u00a7f";
    public static final String OBFUSCATED = "\u00a7k";
    public static final String BOLD = "\u00a7l";
    public static final String STRIKETHROUGH = "\u00a7m";
    public static final String UNDERLINE = "\u00a7n";
    public static final String ITALIC = "\u00a7o";
    public static final String END = "\u00a7r";
    public static boolean displayShiftForDetail = true;
    public static boolean displayStackCount = false;

    private StringHelper() {
    }

    public static String toString(Object o, String nullDefault) {
        return o != null ? o.toString() : nullDefault;
    }

    public static boolean isAltKeyDown() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }

    public static boolean isControlKeyDown() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static int getSplitStringHeight(FontRenderer fontRenderer, String input, int width) {
        List stringRows = fontRenderer.func_78271_c(input, width);
        return stringRows.size() * fontRenderer.field_78288_b;
    }

    public static String titleCase(String input) {
        return input.substring(0, 1).toUpperCase(Locale.US) + input.substring(1);
    }

    public static String localize(String key) {
        return I18n.func_74838_a((String)key);
    }

    public static String localizeFormat(String key, Object ... format) {
        return I18n.func_74837_a((String)key, (Object[])format);
    }

    public static boolean canLocalize(String key) {
        return I18n.func_94522_b((String)key);
    }

    public static String getKeyName(int key) {
        if (key < 0) {
            return I18n.func_74837_a((String)"key.mouseButton", (Object[])new Object[]{key + 101});
        }
        if (key > 256) {
            return Keyboard.getKeyName((int)0);
        }
        return Keyboard.getKeyName((int)key);
    }

    public static String getFluidName(FluidStack stack) {
        Fluid fluid = stack.getFluid();
        String name = END;
        if (fluid.getRarity() == EnumRarity.UNCOMMON) {
            name = name + YELLOW;
        } else if (fluid.getRarity() == EnumRarity.RARE) {
            name = name + BRIGHT_BLUE;
        } else if (fluid.getRarity() == EnumRarity.EPIC) {
            name = name + PINK;
        }
        name = name + fluid.getLocalizedName(stack) + END;
        return name;
    }

    public static String getFluidName(FluidStack stack, String defaultName) {
        if (stack == null) {
            return defaultName;
        }
        return StringHelper.getFluidName(stack);
    }

    public static String getItemName(ItemStack stack) {
        String name = END;
        if (stack.func_77953_t() == EnumRarity.UNCOMMON) {
            name = name + YELLOW;
        } else if (stack.func_77953_t() == EnumRarity.RARE) {
            name = name + BRIGHT_BLUE;
        } else if (stack.func_77953_t() == EnumRarity.EPIC) {
            name = name + PINK;
        }
        name = name + stack.func_82833_r() + END;
        return name;
    }

    public static String getScaledNumber(long number) {
        if (number >= 1000000000L) {
            return number / 1000000000L + "." + number % 1000000000L / 100000000L + number % 100000000L / 10000000L + "G";
        }
        if (number >= 1000000L) {
            return number / 1000000L + "." + number % 1000000L / 100000L + number % 100000L / 10000L + "M";
        }
        if (number >= 1000L) {
            return number / 1000L + "." + number % 1000L / 100L + number % 100L / 10L + "k";
        }
        return String.valueOf(number);
    }

    public static String toNumerals(short v) {
        String s = "potion.potency." + v;
        if (I18n.func_94522_b((String)s)) {
            return I18n.func_74837_a((String)s, (Object[])new Object[0]);
        }
        StringBuilder r = new StringBuilder();
        int i = v;
        if (i < 0) {
            i = -i;
            r.append('-');
        }
        for (Numeral k : Numeral.values) {
            int j = i / k.value;
            while (j-- > 0) {
                r.append(k.name);
            }
            i %= k.value;
        }
        return r.toString();
    }

    public static String formatNumber(long number) {
        return NumberFormat.getInstance().format(number);
    }

    public static String getActivationText(String key) {
        return BRIGHT_BLUE + StringHelper.localize(key) + END;
    }

    public static String getDeactivationText(String key) {
        return YELLOW + StringHelper.localize(key) + END;
    }

    public static String getInfoText(String key) {
        return BRIGHT_GREEN + StringHelper.localize(key) + END;
    }

    public static String getNoticeText(String key) {
        return ORANGE + StringHelper.localize(key) + END;
    }

    public static String getFlavorText(String key) {
        return "\u00a77\u00a7o" + StringHelper.localize(key) + END;
    }

    public static String getRarity(int level) {
        switch (level) {
            case 2: {
                return YELLOW;
            }
            case 3: {
                return BRIGHT_BLUE;
            }
        }
        return LIGHT_GRAY;
    }

    public static String shiftForDetails() {
        return StringHelper.localize("info.cofh.holdShiftForDetails");
    }

    public static String tutorialTabAugment() {
        return StringHelper.localize("info.cofh.tutorial.tabAugment");
    }

    public static String tutorialTabAugmentUpgrade() {
        return StringHelper.localize("info.cofh.tutorial.tabAugmentUpgrade");
    }

    public static String tutorialTabConfiguration() {
        return StringHelper.localize("info.cofh.tutorial.tabConfiguration");
    }

    public static String tutorialTabRedstone() {
        return StringHelper.localize("info.cofh.tutorial.tabRedstone");
    }

    public static String tutorialTabSecurity() {
        return StringHelper.localize("info.cofh.tutorial.tabSecurity");
    }

    public static String tutorialTabFluxRequired() {
        return StringHelper.localize("info.cofh.tutorial.fluxRequired");
    }

    private static enum Numeral {
        M(1000),
        CM(900),
        D(500),
        CD(400),
        C(100),
        XC(90),
        L(50),
        XL(40),
        X(10),
        IX(9),
        V(5),
        IV(4),
        I(1);

        public final String name = this.name();
        public final int value;
        private static final Numeral[] values;

        private Numeral(int val) {
            this.value = val;
        }

        static {
            values = Numeral.values();
        }
    }
}

