/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.toolleveling;

import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.mantle.network.NetworkWrapper;
import slimeknights.toolleveling.CommonProxy;
import slimeknights.toolleveling.EntityXpHandler;
import slimeknights.toolleveling.EventHandler;
import slimeknights.toolleveling.ModToolLeveling;
import slimeknights.toolleveling.capability.CapabilityDamageXp;
import slimeknights.toolleveling.config.Config;
import slimeknights.toolleveling.config.ConfigSync;
import slimeknights.toolleveling.config.ConfigSyncPacket;
import slimeknights.toolleveling.debug.CommandLevelTool;

@Mod(modid="tinkertoolleveling", version="1.12.2-1.1.0.DEV.b23e769", name="TinkerToolLeveling", dependencies="required-after:forge@[14.21.1.2410,);required-after:mantle@[1.12-1.3.1.21,);required-after:tconstruct@[1.12-2.10,)", acceptedMinecraftVersions="[1.12,1.13)")
public class TinkerToolLeveling {
    public static final String MODID = "tinkertoolleveling";
    public static final String VERSION = "1.12.2-1.1.0.DEV.b23e769";
    @SidedProxy(clientSide="slimeknights.toolleveling.CommonProxy", serverSide="slimeknights.toolleveling.CommonProxy")
    public static CommonProxy proxy;
    public static NetworkWrapper networkWrapper;
    public static ModToolLeveling modToolLeveling;
    private File modConfigurationDirectory;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.modConfigurationDirectory = event.getModConfigurationDirectory();
        networkWrapper = new NetworkWrapper("tinkerlevel:sync");
        networkWrapper.registerPacketClient(ConfigSyncPacket.class);
        CapabilityDamageXp.register();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    protected void registerTools(RegistryEvent.Register<Item> event) {
        Config.INSTANCE.load(new File(this.modConfigurationDirectory, "TinkerToolLeveling.cfg"));
        Config.INSTANCE.save();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)EventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)EntityXpHandler.INSTANCE);
        if (event.getSide().isServer()) {
            MinecraftForge.EVENT_BUS.register((Object)new ConfigSync());
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandLevelTool());
    }

    static {
        modToolLeveling = new ModToolLeveling();
    }
}

