/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity.tank;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidStack;
import openmods.utils.Diagonal;

public class TankRenderUtils {
    private static final float UPPER_CLAMP_LIMIT = 0.95f;
    private static final float UPPER_CLAMP_VALUE = 1.0f;
    private static final float LOWER_CLAMP_LIMIT = 0.05f;
    public static final float LOWER_CLAMP_VALUE = 0.05f;
    private static final float PHASE_PER_DISTANCE = 0.5f;
    private static final float WAVE_AMPLITUDE = 0.025f;
    private static final float WAVE_FREQUENCY = 0.1f;

    public static float clampLevel(float level) {
        if (level <= 0.05f) {
            return 0.05f;
        }
        if (level >= 0.95f) {
            return 1.0f;
        }
        return level;
    }

    public static float calculatePhase(int x, int y, int z, Diagonal diagonal) {
        float posX = (float)x + (float)diagonal.offsetX / 2.0f;
        float posY = (float)y + (float)diagonal.offsetY / 2.0f;
        float posZ = (float)z + (float)diagonal.offsetZ / 2.0f;
        return (posX + posY + posZ) * 0.5f;
    }

    public static float calculatePhase(int x, int y, int z) {
        return (float)(x + y + z) * 0.5f;
    }

    private static float calculateWaveAmplitude(float time, float phase) {
        return MathHelper.func_76126_a((float)(time * 0.1f + phase)) * 0.025f;
    }

    public static float calculateRenderHeight(float time, float phase, float level) {
        if (level >= 1.0f) {
            return 1.0f;
        }
        if ((level = TankRenderUtils.clampLevel(level) + TankRenderUtils.calculateWaveAmplitude(time, phase)) <= 0.0f) {
            return 0.0f;
        }
        if (level >= 1.0f) {
            return 1.0f;
        }
        return level;
    }

    public static FluidStack safeCopy(FluidStack stack) {
        return stack != null ? stack.copy() : null;
    }

    public static TileEntity getTileEntitySafe(World world, BlockPos pos) {
        if (world.func_175667_e(pos)) {
            Chunk chunk = world.func_175726_f(pos);
            return chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
        }
        return null;
    }
}

