/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.rpc;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import openmods.OpenMods;
import openmods.network.Dispatcher;
import openmods.network.ExtendedOutboundHandler;
import openmods.network.rpc.IRpcTarget;
import openmods.network.rpc.MethodEntry;
import openmods.network.rpc.RpcCallCodec;
import openmods.network.rpc.RpcCallInboundHandler;
import openmods.network.rpc.RpcIgnore;
import openmods.network.rpc.RpcProxyFactory;
import openmods.network.rpc.TargetTypeProvider;
import openmods.network.senders.IPacketSender;
import openmods.utils.CommonRegistryCallbacks;
import openmods.utils.RegistrationContextBase;
import org.objectweb.asm.Type;

@Mod.EventBusSubscriber
public class RpcCallDispatcher
extends Dispatcher {
    private static RpcCallDispatcher INSTANCE;
    public static final String CHANNEL_NAME = "OpenMods|RPC";
    public final Dispatcher.Senders senders;
    private final RpcProxyFactory proxyFactory;
    private final Map<Side, FMLEmbeddedChannel> channels;
    public static final String ID_FIELDS_SEPARATOR = ";";

    public static RpcCallDispatcher instance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public static void registerRegistry(RegistryEvent.NewRegistry e) {
        IForgeRegistry methodRegistry = new RegistryBuilder().setIDRange(0, 1048575).setName(OpenMods.location("rpc_methods")).setType(MethodEntry.class).disableSaving().addCallback((Object)new MethodsCallbacks()).create();
        IForgeRegistry targetRegistry = new RegistryBuilder().setIDRange(0, 255).setName(OpenMods.location("rpc_targets")).setType(TargetTypeProvider.class).disableSaving().addCallback((Object)new TargetTypeCallbacks()).create();
        INSTANCE = new RpcCallDispatcher((IForgeRegistry<MethodEntry>)methodRegistry, (IForgeRegistry<TargetTypeProvider>)targetRegistry);
    }

    private RpcCallDispatcher(IForgeRegistry<MethodEntry> methodRegistry, IForgeRegistry<TargetTypeProvider> targetRegistry) {
        this.channels = NetworkRegistry.INSTANCE.newChannel(CHANNEL_NAME, new ChannelHandler[]{new RpcCallCodec(targetRegistry, methodRegistry), new RpcCallInboundHandler()});
        ExtendedOutboundHandler.install(this.channels);
        this.senders = new Dispatcher.Senders();
        this.proxyFactory = new RpcProxyFactory(methodRegistry);
    }

    protected FMLEmbeddedChannel getChannel(Side side) {
        return this.channels.get(side);
    }

    public <T> T createProxy(IRpcTarget wrapper, IPacketSender sender, Class<? extends T> mainIntf, Class<?> ... extraIntf) {
        return this.proxyFactory.createProxy(this.getClass().getClassLoader(), sender, wrapper, mainIntf, extraIntf);
    }

    public static MethodRegistrationContext startMethodRegistration(IForgeRegistry<MethodEntry> registry) {
        return new MethodRegistrationContext(registry);
    }

    public static MethodRegistrationContext startMethodRegistration(String domain, IForgeRegistry<MethodEntry> registry) {
        return new MethodRegistrationContext(registry, domain);
    }

    public static TargetRegistrationContext startTargetRegistration(IForgeRegistry<TargetTypeProvider> registry) {
        return new TargetRegistrationContext(registry);
    }

    public static TargetRegistrationContext startTargetRegistration(String domain, IForgeRegistry<TargetTypeProvider> registry) {
        return new TargetRegistrationContext(registry, domain);
    }

    public static class TargetRegistrationContext
    extends RegistrationContextBase<TargetTypeProvider> {
        public TargetRegistrationContext(IForgeRegistry<TargetTypeProvider> registry, String domain) {
            super(registry, domain);
        }

        public TargetRegistrationContext(IForgeRegistry<TargetTypeProvider> registry) {
            super(registry);
        }

        public TargetRegistrationContext registerTargetWrapper(final Class<? extends IRpcTarget> cls) {
            Constructor<? extends IRpcTarget> ctor;
            try {
                ctor = cls.getConstructor(new Class[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Class " + cls + " has no parameterless constructor");
            }
            ResourceLocation targetId = new ResourceLocation(this.domain, cls.getName());
            this.registry.register((IForgeRegistryEntry)new TargetTypeProvider(){

                @Override
                public Class<? extends IRpcTarget> getTargetClass() {
                    return cls;
                }

                @Override
                public IRpcTarget createRpcTarget() {
                    try {
                        return (IRpcTarget)ctor.newInstance(new Object[0]);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new RuntimeException(e);
                    }
                }

                public String toString() {
                    return "RPC target wrapper{" + cls + "}";
                }
            }.setRegistryName(targetId));
            return this;
        }
    }

    public static class MethodRegistrationContext
    extends RegistrationContextBase<MethodEntry> {
        public MethodRegistrationContext(IForgeRegistry<MethodEntry> registry, String domain) {
            super(registry, domain);
        }

        public MethodRegistrationContext(IForgeRegistry<MethodEntry> registry) {
            super(registry);
        }

        public MethodRegistrationContext registerInterface(Class<?> intf) {
            Preconditions.checkArgument((boolean)intf.isInterface(), (String)"Class %s is not interface", intf);
            for (Method m : intf.getMethods()) {
                if (m.isAnnotationPresent(RpcIgnore.class)) continue;
                Preconditions.checkArgument((m.getReturnType() == Void.TYPE ? 1 : 0) != 0, (String)"RPC methods cannot have return type (method = %s)", (Object)m);
                String entry = m.getDeclaringClass().getName() + RpcCallDispatcher.ID_FIELDS_SEPARATOR + m.getName() + RpcCallDispatcher.ID_FIELDS_SEPARATOR + Type.getMethodDescriptor((Method)m);
                ResourceLocation location = new ResourceLocation(this.domain, entry);
                this.registry.register((IForgeRegistryEntry)new MethodEntry(m).setRegistryName(location));
            }
            return this;
        }
    }

    private static class TargetTypeCallbacks
    extends CommonRegistryCallbacks<Class<? extends IRpcTarget>, TargetTypeProvider> {
        private TargetTypeCallbacks() {
        }

        @Override
        protected Class<? extends IRpcTarget> getWrappedObject(TargetTypeProvider entry) {
            return entry.getTargetClass();
        }
    }

    private static class MethodsCallbacks
    extends CommonRegistryCallbacks<Method, MethodEntry> {
        private MethodsCallbacks() {
        }

        @Override
        protected Method getWrappedObject(MethodEntry entry) {
            return entry.method;
        }
    }
}

