/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import info.openmods.calc.executable.IExecutable;
import info.openmods.calc.executable.SymbolCall;
import info.openmods.calc.executable.UnaryOperator;
import info.openmods.calc.executable.Value;
import info.openmods.calc.parsing.node.IExprNode;
import info.openmods.calc.types.multi.ArgUnpackCompilerHelper;
import info.openmods.calc.types.multi.Code;
import info.openmods.calc.types.multi.TypeDomain;
import info.openmods.calc.types.multi.TypedValue;
import java.util.ArrayList;
import java.util.List;

public class ApplyCallNode
implements IExprNode<TypedValue> {
    public final IExprNode<TypedValue> target;
    public final IExprNode<TypedValue> args;
    private final UnaryOperator<TypedValue> unpackMarker;

    public ApplyCallNode(UnaryOperator<TypedValue> unpackMarker, IExprNode<TypedValue> target, IExprNode<TypedValue> args) {
        this.target = target;
        this.args = args;
        this.unpackMarker = unpackMarker;
    }

    @Override
    public void flatten(List<IExecutable<TypedValue>> output) {
        this.target.flatten(output);
        this.flattenArgsAndSymbol(output);
    }

    protected void flattenArgsAndSymbol(final List<IExecutable<TypedValue>> output) {
        new ArgUnpackCompilerHelper(this.unpackMarker){

            @Override
            protected void compileWithVarArgs(int normalArgCount, List<IExecutable<TypedValue>> compiledArgs) {
                output.addAll(compiledArgs);
                output.add(new SymbolCall("applyvar", normalArgCount + 2, 1));
            }

            @Override
            protected void compileWithoutVarArgs(int allArgs, List<IExecutable<TypedValue>> compiledArgs) {
                output.addAll(compiledArgs);
                output.add(new SymbolCall("apply", allArgs + 1, 1));
            }
        }.compileArgUnpack(this.args.getChildren());
    }

    @Override
    public Iterable<IExprNode<TypedValue>> getChildren() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(this.target);
        builder.addAll(this.args.getChildren());
        return builder.build();
    }

    public static class NullAware
    extends ApplyCallNode {
        private final TypeDomain domain;

        public NullAware(UnaryOperator<TypedValue> unpackMarker, IExprNode<TypedValue> target, IExprNode<TypedValue> args, TypeDomain domain) {
            super(unpackMarker, target, args);
            this.domain = domain;
        }

        @Override
        public void flatten(List<IExecutable<TypedValue>> output) {
            this.target.flatten(output);
            ArrayList nonNullOp = Lists.newArrayList();
            this.flattenArgsAndSymbol(nonNullOp);
            output.add(Value.create(Code.wrap(this.domain, nonNullOp)));
            output.add(new SymbolCall("nexecute", 2, 1));
        }
    }
}

