/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.common.unit;

import engineers.workshop.client.container.slot.smelting.SlotUnitFurnaceInput;
import engineers.workshop.client.container.slot.smelting.SlotUnitFurnaceQueue;
import engineers.workshop.client.container.slot.smelting.SlotUnitFurnaceResult;
import engineers.workshop.client.page.Page;
import engineers.workshop.common.items.Upgrade;
import engineers.workshop.common.table.TileTable;
import engineers.workshop.common.unit.Unit;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class UnitSmelt
extends Unit {
    private static final int QUEUE_MAX_COUNT = 3;
    private static final int QUEUE_X = 5;
    private static final int QUEUE_Y = 5;
    private static final int START_X = 25;
    private static final int START_Y = 23;
    private static final int RESULT_X = 56;
    private static final int SLOT_SIZE = 18;
    private static final int[] QUEUE_ORDER = new int[]{2, 0, 1};
    private static final int[] QUEUE_ORDER_START = new int[]{1, 1, 0};
    private static final int ARROW_X = 25;
    private static final int ARROW_Y = 1;
    private int inputId;
    private int outputId;
    private int queueId;

    public UnitSmelt(TileTable table, Page page, int id, int x, int y) {
        super(table, page, id, x, y);
    }

    @Override
    public int createSlots(int id) {
        this.inputId = id;
        this.addSlot(new SlotUnitFurnaceInput(this.table, this.page, id++, this.x + 25, this.y + 23, this));
        this.outputId = id;
        this.addSlot(new SlotUnitFurnaceResult(this.table, this.page, id++, this.x + 25 + 56, this.y + 23, this));
        this.queueId = id;
        for (int i = 0; i < 3; ++i) {
            this.addSlot(new SlotUnitFurnaceQueue(this.table, this.page, id++, this.x + 5, this.y + 5 + i * 18, this, QUEUE_ORDER[i]));
        }
        return id;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        int queueLength = this.table.getUpgradePage().getUpgradeCount(this.id, Upgrade.QUEUE);
        if (queueLength > 0) {
            int start = QUEUE_ORDER_START[queueLength - 1];
            for (int i = start + queueLength - 1; i >= start; --i) {
                int targetId = i == start + queueLength - 1 ? this.inputId : this.queueId + i + 1;
                int sourceId = this.queueId + i;
                ItemStack target = this.table.func_70301_a(targetId);
                ItemStack source = this.table.func_70301_a(sourceId);
                if (source.func_190926_b()) continue;
                ItemStack move = source.func_77946_l();
                move.func_190920_e(1);
                if (!this.canMove(move, target)) continue;
                if (target.func_190926_b()) {
                    this.table.func_70299_a(targetId, move);
                } else {
                    target.func_190917_f(1);
                }
                source.func_190918_g(1);
            }
        }
    }

    @Override
    @Nonnull
    protected ItemStack getProductionResult() {
        ItemStack input = this.table.func_70301_a(this.inputId);
        return input.func_190926_b() ? ItemStack.field_190927_a : FurnaceRecipes.func_77602_a().func_151395_a(input);
    }

    @Override
    protected void onProduction(ItemStack result) {
        this.table.func_70298_a(this.inputId, 1);
    }

    @Override
    public int getOutputId() {
        return this.outputId;
    }

    @Override
    public boolean isEnabled() {
        ItemStack item = this.table.getUpgradePage().getUpgradeMainItem(this.id);
        return !item.func_190926_b() && Upgrade.ParentType.SMELTING.isValidParent(item);
    }

    @Override
    public int getArrowX() {
        return 50;
    }

    @Override
    public int getArrowY() {
        return 24;
    }

    @Override
    public int getPowerConsumption(boolean charging) {
        return super.getPowerConsumption(charging) * 2;
    }
}

