/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates.render;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import pl.asie.charset.lib.render.model.ModelFactory;
import pl.asie.charset.lib.render.model.SimpleBakedModel;
import pl.asie.simplelogic.gates.logic.GateLogicBundledTransposer;
import pl.asie.simplelogic.gates.logic.IGateContainer;
import pl.asie.simplelogic.gates.render.GateCustomRenderer;

public class GateCustomRendererTransposer
extends GateCustomRenderer<GateLogicBundledTransposer> {
    public static TextureAtlasSprite STRIPES;
    public static TextureAtlasSprite WHITE;
    public static IBakedModel[] rayModels;

    @Override
    public Class<GateLogicBundledTransposer> getLogicClass() {
        return GateLogicBundledTransposer.class;
    }

    private BakedQuad makeQuad(float x1, float x2, float y1, float y2, float width, float height, int col, TextureAtlasSprite sprite, boolean isItem, boolean invertY) {
        VertexFormat fmt = isItem ? DefaultVertexFormats.field_176599_b : DefaultVertexFormats.field_176600_a;
        UnpackedBakedQuad.Builder quad = new UnpackedBakedQuad.Builder(fmt);
        quad.setTexture(sprite);
        quad.setQuadOrientation(EnumFacing.UP);
        quad.setApplyDiffuseLighting(true);
        quad.setContractUVs(false);
        quad.setQuadTint(-1);
        for (int vc = 0; vc < 4; ++vc) {
            block19: for (int el = 0; el < fmt.func_177345_h(); ++el) {
                switch (fmt.func_177348_c(el).func_177375_c()) {
                    case POSITION: {
                        switch (vc) {
                            case 0: {
                                quad.put(el, new float[]{x1 - width, height, y1});
                                break;
                            }
                            case 1: {
                                quad.put(el, new float[]{x1 + width, height, y1});
                                break;
                            }
                            case 2: {
                                quad.put(el, new float[]{x2 + width, height, y2});
                                break;
                            }
                            case 3: {
                                quad.put(el, new float[]{x2 - width, height, y2});
                            }
                        }
                        continue block19;
                    }
                    case NORMAL: {
                        quad.put(el, new float[]{0.0f, 1.0f, 0.0f});
                        continue block19;
                    }
                    case COLOR: {
                        quad.put(el, new float[]{(float)(col >> 16 & 0xFF) / 255.0f, (float)(col >> 8 & 0xFF) / 255.0f, (float)(col & 0xFF) / 255.0f, (float)(col >> 24 & 0xFF) / 255.0f});
                        continue block19;
                    }
                    case UV: {
                        if (fmt.func_177348_c(el).func_177369_e() == 0) {
                            switch (vc) {
                                case 0: {
                                    quad.put(el, new float[]{sprite.func_94209_e(), invertY ? sprite.func_94206_g() : sprite.func_94210_h()});
                                    break;
                                }
                                case 1: {
                                    quad.put(el, new float[]{sprite.func_94212_f(), invertY ? sprite.func_94206_g() : sprite.func_94210_h()});
                                    break;
                                }
                                case 2: {
                                    quad.put(el, new float[]{sprite.func_94212_f(), !invertY ? sprite.func_94206_g() : sprite.func_94210_h()});
                                    break;
                                }
                                case 3: {
                                    quad.put(el, new float[]{sprite.func_94209_e(), !invertY ? sprite.func_94206_g() : sprite.func_94210_h()});
                                }
                            }
                            continue block19;
                        }
                        quad.put(el, new float[0]);
                        continue block19;
                    }
                    default: {
                        quad.put(el, new float[0]);
                    }
                }
            }
        }
        return quad.build();
    }

    @Override
    public void renderStatic(IGateContainer gate, GateLogicBundledTransposer logic, boolean isItem, Consumer<IBakedModel> modelConsumer, BiConsumer<BakedQuad, EnumFacing> quadConsumer) {
        if (rayModels == null) {
            rayModels = new IBakedModel[256];
        }
        float width = 0.0078125f;
        if (isItem) {
            width *= 2.0f;
        }
        for (int from = 0; from < 16; ++from) {
            int v = logic.transpositionMap[from];
            int i = 0;
            while (v != 0) {
                if ((v & 1) != 0) {
                    int pos = from << 4 | i;
                    if (rayModels[pos] == null || ModelFactory.DISABLE_CACHE) {
                        SimpleBakedModel model = new SimpleBakedModel();
                        int color1 = EnumDyeColor.func_176764_b((int)from).func_193350_e() | 0xDF000000;
                        int color2 = EnumDyeColor.func_176764_b((int)i).func_193350_e() | 0xDF000000;
                        float x1 = 2.375f + (float)from * 12.0f / 16.0f;
                        float x2 = 2.375f + (float)i * 12.0f / 16.0f;
                        float y1 = 11.025f;
                        float y2 = 4.975f;
                        float height = 0.1875f - (float)(from * 16 + i) / 65536.0f;
                        if (color1 == color2) {
                            model.addQuad(null, this.makeQuad(x1 / 16.0f, x2 / 16.0f, y1 / 16.0f, y2 / 16.0f, width, height, color1, WHITE, isItem, false));
                        } else {
                            model.addQuad(null, this.makeQuad(x1 / 16.0f, x2 / 16.0f, y1 / 16.0f, y2 / 16.0f, width, height, color1, STRIPES, isItem, false));
                            model.addQuad(null, this.makeQuad(x1 / 16.0f, x2 / 16.0f, y1 / 16.0f, y2 / 16.0f, width, height, color2, STRIPES, isItem, true));
                        }
                        GateCustomRendererTransposer.rayModels[pos] = model;
                    }
                    modelConsumer.accept(this.getTransformedModel(rayModels[pos], gate));
                }
                v >>= 1;
                ++i;
            }
        }
    }
}

