/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates.render;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.model.IModelState;
import pl.asie.charset.lib.render.model.ModelTransformer;
import pl.asie.simplelogic.gates.SimpleLogicGates;
import pl.asie.simplelogic.gates.logic.GateLogic;
import pl.asie.simplelogic.gates.logic.IGateContainer;
import pl.asie.simplelogic.gates.render.FastTESRGate;
import pl.asie.simplelogic.gates.render.RendererGate;

public abstract class GateCustomRenderer<T extends GateLogic> {
    public abstract Class<T> getLogicClass();

    public void renderStatic(IGateContainer gate, T logic, boolean isItem, Consumer<IBakedModel> modelConsumer, BiConsumer<BakedQuad, EnumFacing> quadConsumer) {
    }

    public boolean hasDynamic() {
        return false;
    }

    public void renderDynamic(IGateContainer gate, T logic, IBlockAccess world, double x, double y, double z, float partialTicks, int destroyStage, float partial, BufferBuilder buffer) {
    }

    protected final IBakedModel getTransformedModel(IBakedModel model, IGateContainer gate) {
        return this.getTransformedModel(model, null, gate);
    }

    protected final IBakedModel getTransformedModel(IBakedModel model, @Nullable ModelTransformer.IVertexTransformer transformer, IGateContainer gate) {
        ModelTransformer.IVertexTransformer rotate = ModelTransformer.IVertexTransformer.transform((IModelState)RendererGate.INSTANCE.getTransform(gate), null);
        return ModelTransformer.transform((IBakedModel)model, (IBlockState)SimpleLogicGates.blockGate.func_176223_P(), (long)0L, (ModelTransformer.IVertexTransformer)(transformer != null ? ModelTransformer.IVertexTransformer.compose((ModelTransformer.IVertexTransformer[])new ModelTransformer.IVertexTransformer[]{transformer, rotate}) : rotate));
    }

    protected final void renderTransformedModel(IBakedModel model, IGateContainer gate, IBlockAccess world, double x, double y, double z, BufferBuilder buffer) {
        this.renderTransformedModel(model, null, gate, world, x, y, z, buffer);
    }

    protected final void renderTransformedModel(IBakedModel model, @Nullable ModelTransformer.IVertexTransformer transformer, IGateContainer gate, IBlockAccess world, double x, double y, double z, BufferBuilder buffer) {
        model = this.getTransformedModel(model, transformer, gate);
        BlockPos pos = gate.getGatePos();
        buffer.func_178969_c(x - (double)pos.func_177958_n(), y - (double)pos.func_177956_o(), z - (double)pos.func_177952_p());
        FastTESRGate.renderer.func_178267_a(world, model, SimpleLogicGates.blockGate.func_176223_P(), pos, buffer, false);
        buffer.func_178969_c(0.0, 0.0, 0.0);
    }
}

