/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.capability.DummyCapabilityStorage;
import pl.asie.charset.lib.command.CommandCharset;
import pl.asie.charset.lib.command.SubCommand;
import pl.asie.charset.lib.config.CharsetLoadConfigEvent;
import pl.asie.charset.lib.config.ConfigUtils;
import pl.asie.charset.lib.handlers.ShiftScrollHandler;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.network.PacketRegistry;
import pl.asie.charset.lib.utils.RegistryUtils;
import pl.asie.charset.shared.SimpleLogicShared;
import pl.asie.simplelogic.gates.BlockGate;
import pl.asie.simplelogic.gates.ItemGate;
import pl.asie.simplelogic.gates.PacketGateOpenGUI;
import pl.asie.simplelogic.gates.PacketTimerChangeTT;
import pl.asie.simplelogic.gates.PacketTransposerConnection;
import pl.asie.simplelogic.gates.PartGate;
import pl.asie.simplelogic.gates.ProxyCommon;
import pl.asie.simplelogic.gates.SubCommandGateTickLength;
import pl.asie.simplelogic.gates.addon.GateRegisterEvent;
import pl.asie.simplelogic.gates.logic.GateLogic;
import pl.asie.simplelogic.gates.logic.GateLogicBuffer;
import pl.asie.simplelogic.gates.logic.GateLogicBundledInverter;
import pl.asie.simplelogic.gates.logic.GateLogicBundledTransceiver;
import pl.asie.simplelogic.gates.logic.GateLogicBundledTransposer;
import pl.asie.simplelogic.gates.logic.GateLogicComparator;
import pl.asie.simplelogic.gates.logic.GateLogicMultiplexer;
import pl.asie.simplelogic.gates.logic.GateLogicNAND;
import pl.asie.simplelogic.gates.logic.GateLogicNOR;
import pl.asie.simplelogic.gates.logic.GateLogicPulseFormer;
import pl.asie.simplelogic.gates.logic.GateLogicRSLatch;
import pl.asie.simplelogic.gates.logic.GateLogicRandomizer;
import pl.asie.simplelogic.gates.logic.GateLogicRepeater;
import pl.asie.simplelogic.gates.logic.GateLogicSynchronizer;
import pl.asie.simplelogic.gates.logic.GateLogicTimer;
import pl.asie.simplelogic.gates.logic.GateLogicXOR;
import pl.asie.simplelogic.gates.render.RendererGate;

@CharsetModule(name="simplelogic.gates", profile=ModuleProfile.FORCED, description="Simple logic gates.")
public class SimpleLogicGates {
    @CharsetModule.SidedProxy(clientSide="pl.asie.simplelogic.gates.ProxyClient", serverSide="pl.asie.simplelogic.gates.ProxyCommon")
    public static ProxyCommon proxy;
    @CharsetModule.Instance
    public static SimpleLogicGates INSTANCE;
    @CapabilityInject(value=PartGate.class)
    public static Capability<PartGate> GATE_CAP;
    @CharsetModule.Configuration
    public static Configuration config;
    @CharsetModule.PacketRegistry
    public static PacketRegistry packet;
    public static int redstoneTickLength;
    public static int minTimerTickTime;
    public static boolean onlyBottomFace;
    public static boolean useTESRs;
    public static BlockGate blockGate;
    public static ItemGate itemGate;
    public static Set<String> inversionSensitiveLogics;
    static final BiMap<ResourceLocation, Class<? extends GateLogic>> logicClasses;
    static final Map<ResourceLocation, String> logicUns;
    static final Map<ResourceLocation, ResourceLocation> logicDefinitions;
    static final Set<ItemStack> gateStacks;
    private static GateRegisterEvent addonEvent;

    public static ResourceLocation getId(GateLogic logic) {
        return (ResourceLocation)logicClasses.inverse().get(logic.getClass());
    }

    @Mod.EventHandler
    public void onLoadConfig(CharsetLoadConfigEvent event) {
        onlyBottomFace = ConfigUtils.getBoolean((Configuration)config, (String)"general", (String)"gatesOnlyBottomFace", (boolean)false, (String)"Set to true if you wish that gates only be placed on the bottom face of a block - this is great for vanilla-plus style modpacks!", (boolean)false);
        useTESRs = ConfigUtils.getBoolean((Configuration)config, (String)"client", (String)"forceGateTESRs", (boolean)false, (String)"Forces gates to render using TESRs.", (boolean)false);
        minTimerTickTime = ConfigUtils.getInt((Configuration)config, (String)"general", (String)"minTimerTickTime", (int)4, (int)4, (int)24000, (String)"The minimum amount of ticks, in 1/20-second units, Timers are allowed to tick at.", (boolean)false);
        redstoneTickLength = ConfigUtils.getInt((Configuration)config, (String)"expert", (String)"redstoneTickLength", (int)2, (int)1, (int)20, (String)"The length of a redstone tick, in game ticks (1/20 second units). USE ONLY IF YOU REALLY KNOW WHAT YOU ARE DOING - VALUES OTHER THAN 2 DO *NOT* MATCH VANILLA EXPECTATIONS!", (boolean)false);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void onLoadConfigClient(CharsetLoadConfigEvent event) {
        RendererGate.INSTANCE.invalidate();
    }

    @SubscribeEvent
    public void onRegisterBlock(RegistryEvent.Register<Block> event) {
        RegistryUtils.register((IForgeRegistry)event.getRegistry(), (IForgeRegistryEntry)blockGate, (String)"logic_gate", (CreativeTabs)SimpleLogicShared.getTab());
    }

    @SubscribeEvent
    public void onRegisterItem(RegistryEvent.Register<Item> event) {
        RegistryUtils.register((IForgeRegistry)event.getRegistry(), (IForgeRegistryEntry)itemGate, (String)"logic_gate", (CreativeTabs)SimpleLogicShared.getTab());
    }

    static void sendAddonEventIfNotSent() {
        if (addonEvent == null) {
            addonEvent = new GateRegisterEvent();
            MinecraftForge.EVENT_BUS.post((Event)addonEvent);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        blockGate = new BlockGate();
        itemGate = new ItemGate((Block)blockGate);
        this.registerGate(new ResourceLocation("simplelogic:nand"), GateLogicNAND.class);
        this.registerGate(new ResourceLocation("simplelogic:nor"), GateLogicNOR.class);
        this.registerGate(new ResourceLocation("simplelogic:xor"), GateLogicXOR.class);
        this.registerGate(new ResourceLocation("simplelogic:multiplexer"), GateLogicMultiplexer.class);
        this.registerGate(new ResourceLocation("simplelogic:pulse_former"), GateLogicPulseFormer.class);
        this.registerGate(new ResourceLocation("simplelogic:buffer"), GateLogicBuffer.class);
        this.registerGate(new ResourceLocation("simplelogic:rs_latch"), GateLogicRSLatch.class);
        this.registerGate(new ResourceLocation("simplelogic:randomizer"), GateLogicRandomizer.class);
        this.registerGate(new ResourceLocation("simplelogic:synchronizer"), GateLogicSynchronizer.class);
        if (ModCharset.isModuleLoaded((String)"simplelogic.wires")) {
            this.registerGate(new ResourceLocation("simplelogic:bundled_transceiver"), GateLogicBundledTransceiver.class);
            this.registerGate(new ResourceLocation("simplelogic:bundled_inverter"), GateLogicBundledInverter.class);
            this.registerGate(new ResourceLocation("simplelogic:bundled_transposer"), GateLogicBundledTransposer.class);
        }
        this.registerGate(new ResourceLocation("simplelogic:comparator"), GateLogicComparator.class);
        this.registerGate(new ResourceLocation("simplelogic:repeater"), GateLogicRepeater.class);
        this.registerGate(new ResourceLocation("simplelogic:timer"), GateLogicTimer.class);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        if (!ModCharset.isModuleLoaded((String)"simplelogic.wires") && !gateStacks.isEmpty()) {
            SimpleLogicShared.TAB_ICON = gateStacks.iterator().next();
        }
        if (config.hasChanged()) {
            config.save();
        }
        CapabilityManager.INSTANCE.register(PartGate.class, (Capability.IStorage)DummyCapabilityStorage.get(), PartGate::new);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        packet.registerPacket(1, PacketGateOpenGUI.class);
        packet.registerPacket(2, PacketTimerChangeTT.class);
        packet.registerPacket(3, PacketTransposerConnection.class);
        RegistryUtils.register(PartGate.class, (String)"logic_gate");
        this.registerGateStack(ItemGate.getStack(new PartGate(new GateLogicNOR()).setInvertedSides(1)));
        this.registerGateStack(ItemGate.getStack(new PartGate(new GateLogicNAND()).setInvertedSides(1)));
        this.registerGateStack(ItemGate.getStack(new PartGate(new GateLogicXOR())));
        this.registerGateStack(ItemGate.getStack(new PartGate(new GateLogicNOR())));
        this.registerGateStack(ItemGate.getStack(new PartGate(new GateLogicNAND())));
        this.registerGateStack(ItemGate.getStack(new PartGate(new GateLogicXOR()).setInvertedSides(1)));
        this.registerGateStack(ItemGate.getStack(new PartGate(new GateLogicMultiplexer())));
        this.registerGateStack(ItemGate.getStack(new PartGate(new GateLogicPulseFormer())));
        this.registerGateStack(ItemGate.getStack(new PartGate(new GateLogicBuffer())));
        this.registerGateStack(ItemGate.getStack(new PartGate(new GateLogicBuffer()).setInvertedSides(1)));
        this.registerGateStack(ItemGate.getStack(new PartGate(new GateLogicRSLatch())));
        this.registerGateStack(ItemGate.getStack(new PartGate(new GateLogicRandomizer())));
        this.registerGateStack(ItemGate.getStack(new PartGate(new GateLogicSynchronizer())));
        if (ModCharset.isModuleLoaded((String)"simplelogic.wires")) {
            this.registerGateStack(ItemGate.getStack(new PartGate(new GateLogicBundledTransceiver())));
            this.registerGateStack(ItemGate.getStack(new PartGate(new GateLogicBundledInverter())));
            this.registerGateStack(ItemGate.getStack(new PartGate(new GateLogicBundledTransposer())));
        }
        this.registerGateStack(ItemGate.getStack(new PartGate(new GateLogicRepeater())));
        this.registerGateStack(ItemGate.getStack(new PartGate(new GateLogicComparator())));
        this.registerGateStack(ItemGate.getStack(new PartGate(new GateLogicTimer())));
        SimpleLogicGates.sendAddonEventIfNotSent();
        for (PartGate p : addonEvent.getGateStackPartList()) {
            this.registerGateStack(ItemGate.getStack(p));
        }
        CommandCharset.register((SubCommand)new SubCommandGateTickLength());
        proxy.init();
        ShiftScrollHandler.INSTANCE.register((ShiftScrollHandler.Provider)new ShiftScrollHandler.ItemGroup(new Item[]{itemGate}));
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onRightClickGate(PlayerInteractEvent.RightClickBlock event) {
        IBlockState state;
        if (event.getEntityPlayer().func_70093_af() && !event.getItemStack().func_190926_b() && (state = event.getWorld().func_180495_p(event.getPos())).func_177230_c() instanceof BlockGate) {
            event.setUseBlock(Event.Result.ALLOW);
            event.setUseItem(Event.Result.DENY);
        }
    }

    public void registerGateStack(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemGate) {
            if (stack.func_77942_o() && stack.func_77978_p().func_74771_c("li") > 0) {
                inversionSensitiveLogics.add(stack.func_77978_p().func_74779_i("logic"));
            }
            gateStacks.add(stack);
        }
    }

    private void registerGate(ResourceLocation name, Class<? extends GateLogic> clazz) {
        this.registerGate(name, clazz, new ResourceLocation(name.func_110624_b(), "gatedefs/" + name.func_110623_a() + ".json"), "tile." + name.func_110624_b() + ".gate." + name.func_110623_a());
    }

    public void registerGate(ResourceLocation name, Class<? extends GateLogic> clazz, ResourceLocation gdLoc, String unl) {
        if (!config.getBoolean(name.toString(), "gates", true, "Enable/disable the " + name.toString() + " gate.")) {
            return;
        }
        logicClasses.put((Object)name, clazz);
        logicDefinitions.put(name, gdLoc);
        logicUns.put(name, unl);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    static {
        inversionSensitiveLogics = new HashSet<String>();
        logicClasses = HashBiMap.create();
        logicUns = new HashMap<ResourceLocation, String>();
        logicDefinitions = new HashMap<ResourceLocation, ResourceLocation>();
        gateStacks = new HashSet<ItemStack>();
    }
}

