/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.splashanimation.core.repackage.com.elytradev.mini;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import pl.asie.splashanimation.core.repackage.com.elytradev.mini.exception.PointerNotSetException;
import pl.asie.splashanimation.core.repackage.com.elytradev.mini.exception.PointerOutOfBoundsException;

public class PatchContext {
    private final MethodNode method;
    private final List<AbstractInsnNode> code;
    private int pointer = -1;

    PatchContext(MethodNode method) {
        AbstractInsnNode ain;
        this.method = method;
        this.code = Lists.newArrayListWithCapacity((int)method.instructions.size());
        IdentityHashMap labels = Maps.newIdentityHashMap();
        for (ain = method.instructions.getFirst(); ain != null; ain = ain.getNext()) {
            if (!(ain instanceof LabelNode)) continue;
            LabelNode l = new LabelNode(((LabelNode)ain).getLabel());
            labels.put((LabelNode)ain, l);
        }
        for (ain = method.instructions.getFirst(); ain != null; ain = ain.getNext()) {
            this.code.add(ain.clone((Map)labels));
        }
    }

    public AbstractInsnNode get() {
        if (this.pointer == -1) {
            throw new PointerNotSetException();
        }
        return this.code.get(this.pointer);
    }

    public String getMethodName() {
        return this.method.name;
    }

    protected void finish() {
        this.method.instructions = new InsnList();
        for (AbstractInsnNode ain : this.code) {
            this.method.instructions.add(ain);
        }
    }

    private PointerOutOfBoundsException pointerOutOfBoundsException(int i) {
        if (i < 0) {
            return new PointerOutOfBoundsException(i + " is before the beginning of the code block");
        }
        return new PointerOutOfBoundsException(i + " is after the end of the code block");
    }

    public void add(AbstractInsnNode ... nodes) {
        if (this.pointer == -1) {
            throw new PointerNotSetException();
        }
        for (int i = 0; i < nodes.length; ++i) {
            this.code.add(this.pointer, nodes[i]);
            ++this.pointer;
        }
    }

    @Deprecated
    public void erase() {
        if (this.pointer == -1) {
            throw new PointerNotSetException();
        }
        this.erase(this.pointer);
    }

    private void setPointer(int pointer) {
        if (pointer < 0) {
            throw this.pointerOutOfBoundsException(pointer);
        }
        if (pointer >= this.method.instructions.size()) {
            throw this.pointerOutOfBoundsException(pointer);
        }
        this.pointer = pointer;
    }

    private void erase(int idx) {
        this.code.remove(idx);
    }

    private void jump(int amt) {
        if (this.pointer == -1) {
            throw new PointerNotSetException();
        }
        this.setPointer(this.pointer + amt);
    }

    @Deprecated
    public void jumpForward(int amt) {
        this.jump(amt);
    }

    @Deprecated
    public void jumpBackward(int amt) {
        this.jump(-amt);
    }

    public void jumpToStart() {
        this.pointer = 0;
    }

    public void jumpToEnd() {
        this.pointer = this.method.instructions.size() - 1;
    }

    public SearchResult search(AbstractInsnNode ... nodes) {
        return this.searchFrom(this.pointer == -1 ? 0 : this.pointer, nodes, false);
    }

    public SearchResult searchBackward(AbstractInsnNode ... nodes) {
        return this.searchFrom(this.pointer == -1 ? 0 : this.pointer, nodes, true);
    }

    private SearchResult searchFrom(int start, AbstractInsnNode[] nodes, boolean reverse) {
        int k = start;
        while (reverse ? k >= 0 : k < this.code.size()) {
            boolean allMatched = true;
            for (int j = 0; j < nodes.length; ++j) {
                if (this.instructionsEqual(this.code.get(k + j), nodes[j])) continue;
                allMatched = false;
                break;
            }
            if (allMatched) {
                return new SearchResult(k, nodes, reverse);
            }
            k += reverse ? -1 : 1;
        }
        return new SearchResult(-1, nodes, reverse);
    }

    private boolean instructionsEqual(AbstractInsnNode a, AbstractInsnNode b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getClass() != b.getClass()) {
            return false;
        }
        if (a.getOpcode() != b.getOpcode()) {
            return false;
        }
        if (a instanceof FieldInsnNode) {
            FieldInsnNode fa = (FieldInsnNode)a;
            FieldInsnNode fb = (FieldInsnNode)b;
            return Objects.equal((Object)fa.owner, (Object)fb.owner) && Objects.equal((Object)fa.name, (Object)fb.name) && Objects.equal((Object)fa.desc, (Object)fb.desc);
        }
        if (a instanceof IincInsnNode) {
            IincInsnNode ia = (IincInsnNode)a;
            IincInsnNode ib = (IincInsnNode)b;
            return ia.var == ib.var && ia.incr == ib.incr;
        }
        if (a instanceof InsnNode) {
            return true;
        }
        if (a instanceof IntInsnNode) {
            IntInsnNode ia = (IntInsnNode)a;
            IntInsnNode ib = (IntInsnNode)b;
            return ia.operand == ib.operand;
        }
        if (a instanceof InvokeDynamicInsnNode) {
            InvokeDynamicInsnNode ia = (InvokeDynamicInsnNode)a;
            InvokeDynamicInsnNode ib = (InvokeDynamicInsnNode)b;
            return Objects.equal((Object)ia.bsm, (Object)ib.bsm) && Arrays.equals(ia.bsmArgs, ib.bsmArgs) && Objects.equal((Object)ia.name, (Object)ib.name) && Objects.equal((Object)ia.desc, (Object)ib.desc);
        }
        if (a instanceof JumpInsnNode) {
            JumpInsnNode ja = (JumpInsnNode)a;
            JumpInsnNode jb = (JumpInsnNode)b;
            return this.instructionsEqual((AbstractInsnNode)ja.label, (AbstractInsnNode)jb.label);
        }
        if (a instanceof LabelNode) {
            return true;
        }
        if (a instanceof LdcInsnNode) {
            LdcInsnNode la = (LdcInsnNode)a;
            LdcInsnNode lb = (LdcInsnNode)b;
            return Objects.equal((Object)la.cst, (Object)lb.cst);
        }
        if (a instanceof LineNumberNode) {
            LineNumberNode la = (LineNumberNode)a;
            LineNumberNode lb = (LineNumberNode)b;
            return la.line == lb.line && this.instructionsEqual((AbstractInsnNode)la.start, (AbstractInsnNode)lb.start);
        }
        if (a instanceof LookupSwitchInsnNode) {
            LookupSwitchInsnNode la = (LookupSwitchInsnNode)a;
            LookupSwitchInsnNode lb = (LookupSwitchInsnNode)b;
            return this.instructionsEqual((AbstractInsnNode)la.dflt, (AbstractInsnNode)lb.dflt) && Objects.equal((Object)la.keys, (Object)lb.keys) && this.instructionListsEqual(la.labels, lb.labels);
        }
        if (a instanceof MethodInsnNode) {
            MethodInsnNode ma = (MethodInsnNode)a;
            MethodInsnNode mb = (MethodInsnNode)b;
            return Objects.equal((Object)ma.owner, (Object)mb.owner) && Objects.equal((Object)ma.name, (Object)mb.name) && Objects.equal((Object)ma.desc, (Object)mb.desc) && ma.itf == mb.itf;
        }
        if (a instanceof MultiANewArrayInsnNode) {
            MultiANewArrayInsnNode ma = (MultiANewArrayInsnNode)a;
            MultiANewArrayInsnNode mb = (MultiANewArrayInsnNode)b;
            return Objects.equal((Object)ma.desc, (Object)mb.desc) && ma.dims == mb.dims;
        }
        if (a instanceof TableSwitchInsnNode) {
            TableSwitchInsnNode ta = (TableSwitchInsnNode)a;
            TableSwitchInsnNode tb = (TableSwitchInsnNode)b;
            return ta.min == tb.min && ta.max == tb.max && this.instructionsEqual((AbstractInsnNode)ta.dflt, (AbstractInsnNode)tb.dflt) && this.instructionListsEqual(ta.labels, tb.labels);
        }
        if (a instanceof TypeInsnNode) {
            TypeInsnNode ta = (TypeInsnNode)a;
            TypeInsnNode tb = (TypeInsnNode)b;
            return Objects.equal((Object)ta.desc, (Object)tb.desc);
        }
        if (a instanceof VarInsnNode) {
            VarInsnNode va = (VarInsnNode)a;
            VarInsnNode vb = (VarInsnNode)b;
            return va.var == vb.var;
        }
        throw new IllegalArgumentException("Unknown insn type " + a.getClass().getName());
    }

    private boolean instructionListsEqual(List<? extends AbstractInsnNode> a, List<? extends AbstractInsnNode> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (this.instructionsEqual(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    public class SearchResult {
        private int start;
        private AbstractInsnNode[] query;
        private boolean reverse;

        protected SearchResult(int start, AbstractInsnNode[] query, boolean reverse) {
            this.start = start;
            this.query = query;
            this.reverse = reverse;
        }

        public boolean isSuccessful() {
            return this.start != -1;
        }

        public void jumpAfter() {
            if (!this.isSuccessful()) {
                throw new NoSuchElementException();
            }
            PatchContext.this.setPointer(this.start + this.query.length);
        }

        public void jumpBefore() {
            if (!this.isSuccessful()) {
                throw new NoSuchElementException();
            }
            PatchContext.this.setPointer(this.start - 1);
        }

        public SearchResult next() {
            if (!this.isSuccessful()) {
                throw new NoSuchElementException();
            }
            return PatchContext.this.searchFrom(this.start + this.query.length, this.query, this.reverse);
        }

        @Deprecated
        public void erase() {
            if (!this.isSuccessful()) {
                throw new NoSuchElementException();
            }
            for (int i = 0; i < this.query.length; ++i) {
                PatchContext.this.erase(this.start);
            }
        }
    }
}

