/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.MessageTagManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.TriFunction;

public class EmoteSets
extends MessageTagManager.DefaultMessageTag {
    public static final String NAME = "emote-sets";
    public static final TriFunction<Client, String, String, EmoteSets> FUNCTION = (client, name, value) -> new EmoteSets((String)name, (String)value);
    private final List<Integer> emoteSets;

    private EmoteSets(@Nonnull String name, @Nullable String value) {
        super(name, value);
        this.emoteSets = value == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.stream(value.split(",")).map(Integer::valueOf).collect(Collectors.toList()));
    }

    @Nonnull
    public List<Integer> getEmoteSets() {
        return this.emoteSets;
    }

    @Override
    @Nonnull
    public ToStringer toStringer() {
        return super.toStringer().add("emoteSets", this.emoteSets);
    }
}

