/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts;

import java.net.InetSocketAddress;
import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsClientState;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsMachine;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsPolicy;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsStorageManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;

public class MemoryStsMachine
implements StsMachine {
    private final StsStorageManager manager;
    private final Client.WithManagement client;
    private StsClientState state = StsClientState.UNKNOWN;
    private StsPolicy policy;

    public MemoryStsMachine(@Nonnull StsStorageManager manager, Client.WithManagement client) {
        this.client = Sanity.nullCheck(client, "Cannot have a null client.");
        this.manager = Sanity.nullCheck(manager, "Cannot have a null STS persistence manager.");
    }

    @Override
    @Nonnull
    public StsClientState getCurrentState() {
        return this.state;
    }

    @Override
    public void setCurrentState(@Nonnull StsClientState newState) {
        this.state = Sanity.nullCheck(newState, "Need a valid state for the state machine.");
        this.step();
    }

    private void step() {
        switch (this.state) {
            case UNKNOWN: {
                throw new IllegalStateException("Unknown state can only be used as an initial state!");
            }
            case STS_POLICY_CACHED: 
            case STS_PRESENT_RECONNECTING: {
                this.client.isSecureConnection();
                InetSocketAddress oldAddress = this.client.getServerAddress();
                InetSocketAddress newAddress = new InetSocketAddress(oldAddress.getHostName(), Integer.parseInt(this.policy.getOptions().getOrDefault("port", "6697")));
                this.client.setServerAddress(newAddress);
                break;
            }
        }
        if (this.state == StsClientState.STS_PRESENT_RECONNECTING) {
            this.client.reconnect();
        }
    }

    @Override
    @Nonnull
    public StsStorageManager getStorageManager() {
        return this.manager;
    }

    @Override
    public void setStsPolicy(@Nonnull StsPolicy policy) {
        this.policy = Sanity.nullCheck(policy, "Policy cannot be null");
    }
}

