/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.mode.DefaultChannelMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.mode.DefaultChannelUserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.mode.DefaultUserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ISupportParameter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelUserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.UserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.ServerInfo;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class DefaultServerInfo
implements ServerInfo.WithManagement {
    private final Client client;
    private final Map<String, ISupportParameter> iSupportParameterMap = new ConcurrentHashMap<String, ISupportParameter>();
    private final List<ChannelMode> defaultChannelModes;
    private final List<Character> defaultChannelPrefixes = Arrays.asList(Character.valueOf('#'), Character.valueOf('&'), Character.valueOf('!'), Character.valueOf('+'));
    private final List<ChannelUserMode> defaultChannelUserModes;
    private List<String> motd;
    private String address;
    private String version;
    private List<UserMode> userModes;
    private final Pattern channelPattern = Pattern.compile("([#!&+][^ ,\\07\\r\\n]+)");

    public DefaultServerInfo(@Nonnull Client client) {
        this.client = client;
        ArrayList<DefaultChannelMode> defaultChannelModes = new ArrayList<DefaultChannelMode>(9);
        defaultChannelModes.add(new DefaultChannelMode(client, 't', ChannelMode.Type.D_PARAMETER_NEVER));
        defaultChannelModes.add(new DefaultChannelMode(client, 's', ChannelMode.Type.D_PARAMETER_NEVER));
        defaultChannelModes.add(new DefaultChannelMode(client, 'p', ChannelMode.Type.D_PARAMETER_NEVER));
        defaultChannelModes.add(new DefaultChannelMode(client, 'n', ChannelMode.Type.D_PARAMETER_NEVER));
        defaultChannelModes.add(new DefaultChannelMode(client, 'm', ChannelMode.Type.D_PARAMETER_NEVER));
        defaultChannelModes.add(new DefaultChannelMode(client, 'i', ChannelMode.Type.D_PARAMETER_NEVER));
        defaultChannelModes.add(new DefaultChannelMode(client, 'l', ChannelMode.Type.C_PARAMETER_ON_SET));
        defaultChannelModes.add(new DefaultChannelMode(client, 'k', ChannelMode.Type.B_PARAMETER_ALWAYS));
        defaultChannelModes.add(new DefaultChannelMode(client, 'b', ChannelMode.Type.A_MASK));
        this.defaultChannelModes = Collections.unmodifiableList(defaultChannelModes);
        ArrayList<DefaultChannelUserMode> defaultChannelUserModes = new ArrayList<DefaultChannelUserMode>(2);
        defaultChannelUserModes.add(new DefaultChannelUserMode(client, 'o', '@'));
        defaultChannelUserModes.add(new DefaultChannelUserMode(client, 'v', '+'));
        this.defaultChannelUserModes = Collections.unmodifiableList(defaultChannelUserModes);
        ArrayList<DefaultUserMode> defaultUserModes = new ArrayList<DefaultUserMode>(4);
        defaultUserModes.add(new DefaultUserMode(client, 'i'));
        defaultUserModes.add(new DefaultUserMode(client, 's'));
        defaultUserModes.add(new DefaultUserMode(client, 'w'));
        defaultUserModes.add(new DefaultUserMode(client, 'o'));
        this.userModes = Collections.unmodifiableList(defaultUserModes);
    }

    @Override
    @Nonnull
    public Optional<String> getAddress() {
        return Optional.ofNullable(this.address);
    }

    @Override
    public void setAddress(@Nonnull String serverAddress) {
        this.address = serverAddress;
    }

    @Override
    @Nonnull
    public List<ChannelMode> getChannelModes() {
        Optional<ISupportParameter.ChanModes> optional = this.getISupportParameter("CHANMODES", ISupportParameter.ChanModes.class);
        return new ArrayList<ChannelMode>((Collection)optional.map(ISupportParameter.ChanModes::getModes).orElse(this.defaultChannelModes));
    }

    @Override
    @Nonnull
    public List<Character> getChannelPrefixes() {
        Optional<ISupportParameter.ChanTypes> optional = this.getISupportParameter("CHANTYPES", ISupportParameter.ChanTypes.class);
        return new ArrayList<Character>((Collection)optional.map(ISupportParameter.ChanTypes::getTypes).orElse(this.defaultChannelPrefixes));
    }

    @Override
    @Nonnull
    public List<ChannelUserMode> getChannelUserModes() {
        Optional<ISupportParameter.Prefix> optional = this.getISupportParameter("PREFIX", ISupportParameter.Prefix.class);
        return new ArrayList<ChannelUserMode>((Collection)optional.map(ISupportParameter.Prefix::getModes).orElse(this.defaultChannelUserModes));
    }

    @Override
    @Nonnull
    public Optional<ISupportParameter> getISupportParameter(@Nonnull String name) {
        Sanity.nullCheck(name, "Name cannot be null");
        return Optional.ofNullable(this.iSupportParameterMap.get(name.toUpperCase()));
    }

    @Override
    @Nonnull
    public Map<String, ISupportParameter> getISupportParameters() {
        return Collections.unmodifiableMap(new HashMap<String, ISupportParameter>(this.iSupportParameterMap));
    }

    @Override
    public void addISupportParameter(@Nonnull ISupportParameter parameter) {
        this.iSupportParameterMap.put(parameter.getName().toUpperCase(), parameter);
    }

    @Override
    @Nonnull
    public Optional<List<String>> getMotd() {
        return Optional.ofNullable(this.motd);
    }

    @Override
    public void setMotd(@Nonnull List<String> motd) {
        this.motd = Collections.unmodifiableList(motd);
    }

    @Override
    @Nonnull
    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    @Override
    public void setVersion(@Nonnull String version) {
        this.version = version;
    }

    @Override
    public boolean isValidChannel(@Nonnull String name) {
        Sanity.nullCheck(name, "Channel name cannot be null");
        int channelLengthLimit = this.getChannelLengthLimit();
        return name.length() > 1 && (channelLengthLimit < 0 || name.length() <= channelLengthLimit) && this.getChannelPrefixes().contains(Character.valueOf(name.charAt(0))) && this.channelPattern.matcher(name).matches();
    }

    @Override
    @Nonnull
    public Optional<ChannelUserMode> getTargetedChannelInfo(@Nonnull String name) {
        if (name.length() < 2) {
            return Optional.empty();
        }
        char first = name.charAt(0);
        String shorter = name.substring(1);
        if (!this.getChannelPrefixes().contains(Character.valueOf(first)) && this.isValidChannel(shorter)) {
            for (ChannelUserMode mode : this.getChannelUserModes()) {
                if (mode.getNickPrefix() != first) continue;
                return Optional.of(mode);
            }
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public List<UserMode> getUserModes() {
        return this.userModes;
    }

    @Override
    public void setUserModes(@Nonnull List<UserMode> userModes) {
        this.userModes = Collections.unmodifiableList(userModes);
    }

    @Nonnull
    public String toString() {
        return new ToStringer(this).add("client", this.client).add("address", this.address).add("version", this.version).add("motd", this.motd).add("channelModes", this.getChannelModes()).add("channelPrefixes", this.getChannelPrefixes()).add("channelUserModes", this.getChannelUserModes()).add("userModes", this.userModes).add("iSupportParameters", this.iSupportParameterMap).toString();
    }
}

