/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.feature;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.AuthManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.auth.AuthProtocol;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.auth.element.EventListening;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class DefaultAuthManager
implements AuthManager {
    private final Client client;
    private final Set<AuthProtocol> protocols = new HashSet<AuthProtocol>();

    public DefaultAuthManager(@Nonnull Client client) {
        this.client = client;
    }

    @Override
    @Nonnull
    public synchronized Optional<AuthProtocol> addProtocol(@Nonnull AuthProtocol protocol) {
        Sanity.nullCheck(protocol, "Protocol cannot be null");
        List matching = this.protocols.stream().filter(p -> p.getClass() == protocol.getClass()).collect(Collectors.toList());
        Optional<Object> removed = Optional.ofNullable(matching.isEmpty() ? null : (AuthProtocol)matching.get(0));
        removed.ifPresent(this::removeProtocol);
        this.protocols.add(protocol);
        if (protocol instanceof EventListening) {
            this.client.getEventManager().registerEventListener(((EventListening)((Object)protocol)).getEventListener());
        }
        return removed;
    }

    @Override
    @Nonnull
    public synchronized Set<AuthProtocol> getProtocols() {
        return Collections.unmodifiableSet(new HashSet<AuthProtocol>(this.protocols));
    }

    @Override
    public synchronized void removeProtocol(@Nonnull AuthProtocol protocol) {
        Sanity.nullCheck(protocol, "Protocol cannot be null");
        this.protocols.remove(protocol);
        if (protocol instanceof EventListening) {
            this.client.getEventManager().unregisterEventListener(((EventListening)((Object)protocol)).getEventListener());
        }
    }

    @Nonnull
    public String toString() {
        return new ToStringer(this).add("client", this.client).toString();
    }
}

