/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.MessageTag;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ServerMessage;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class DefaultServerMessage
implements ServerMessage {
    private final String message;
    private final List<MessageTag> tags;

    public DefaultServerMessage(@Nonnull String message, @Nonnull List<MessageTag> tags) {
        Sanity.nullCheck(message, "Message cannot be null");
        Sanity.nullCheck(tags, "Tags cannot be null");
        this.message = message;
        this.tags = Collections.unmodifiableList(new ArrayList<MessageTag>(tags));
    }

    @Override
    @Nonnull
    public String getMessage() {
        return this.message;
    }

    @Override
    @Nonnull
    public final List<MessageTag> getTags() {
        return this.tags;
    }

    @Nonnull
    public String toString() {
        return new ToStringer(this).add("message", this.message).add("tags", this.tags).toString();
    }

    public static class StringCommand
    extends DefaultServerMessage
    implements ServerMessage.StringCommandServerMessage {
        private final String command;

        public StringCommand(@Nonnull String command, @Nonnull String message, @Nonnull List<MessageTag> tags) {
            super(message, tags);
            this.command = command;
        }

        @Override
        @Nonnull
        public String getCommand() {
            return this.command;
        }
    }

    public static class NumericCommand
    extends DefaultServerMessage
    implements ServerMessage.NumericCommandServerMessage {
        private final int command;

        public NumericCommand(int command, @Nonnull String message, @Nonnull List<MessageTag> tags) {
            super(message, tags);
            this.command = command;
        }

        @Override
        public int getCommand() {
            return this.command;
        }
    }
}

