/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults;

import java.time.DateTimeException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.minetogether.net.engio.mbassy.listener.Handler;
import net.creeperhost.minetogether.net.engio.mbassy.listener.Listener;
import net.creeperhost.minetogether.net.engio.mbassy.listener.References;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.CapabilityRequestCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.DefaultCapabilityState;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.DefaultWhoisData;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.mode.DefaultUserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Actor;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.CapabilityState;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Channel;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Server;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ServerMessage;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.WhoisData;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelUserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ModeInfo;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ModeStatusList;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.UserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.abstractbase.CapabilityNegotiationResponseEventBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.abstractbase.CapabilityNegotiationResponseEventWithRequestBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.abstractbase.MonitoredNickEventBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.capabilities.CapabilitiesAcknowledgedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.capabilities.CapabilitiesDeletedSupportedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.capabilities.CapabilitiesListEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.capabilities.CapabilitiesNewSupportedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.capabilities.CapabilitiesRejectedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.capabilities.CapabilitiesSupportedListEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelCtcpEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelInviteEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelJoinEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelKickEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelKnockEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelMessageEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelModeEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelModeInfoListEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelNamesUpdatedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelNoticeEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelPartEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelTargetedCtcpEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelTargetedMessageEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelTargetedNoticeEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelTopicEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelUsersUpdatedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.RequestedChannelJoinCompleteEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.UnexpectedChannelLeaveViaKickEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.UnexpectedChannelLeaveViaPartEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientAwayStatusChangeEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientNegotiationCompleteEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientReceiveCommandEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientReceiveMotdEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientReceiveNumericEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.NickRejectedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.helper.ClientEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.helper.ClientReceiveServerMessageEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.MonitoredNickListEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.MonitoredNickListFullEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.MonitoredNickOfflineEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.MonitoredNickOnlineEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.PrivateCtcpQueryEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.PrivateCtcpReplyEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.PrivateMessageEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.PrivateNoticeEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.ServerNoticeEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.UserAccountStatusEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.UserAwayMessageEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.UserHostnameChangeEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.UserModeEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.UserNickChangeEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.UserQuitEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.UserUserStringChangeEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.WallopsEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.WhoisEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.exception.KittehServerMessageException;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.ActorTracker;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.CapabilityManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.CommandFilter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.NumericFilter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.TwitchListener;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.CtcpUtil;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.StringUtil;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

@Listener(references=References.Strong)
public class DefaultEventListener {
    private final Client.WithManagement client;
    @Nullable
    private DefaultWhoisData.Builder whoisBuilder;
    private final List<ServerMessage> whoMessages = new ArrayList<ServerMessage>();
    private final List<ServerMessage> namesMessages = new ArrayList<ServerMessage>();
    private final List<ServerMessage> banMessages = new ArrayList<ServerMessage>();
    private final List<ModeInfo> bans = new ArrayList<ModeInfo>();
    private final List<ServerMessage> inviteMessages = new ArrayList<ServerMessage>();
    private final List<ModeInfo> invites = new ArrayList<ModeInfo>();
    private final List<ServerMessage> exceptMessages = new ArrayList<ServerMessage>();
    private final List<ModeInfo> excepts = new ArrayList<ModeInfo>();
    private final List<ServerMessage> quietMessages = new ArrayList<ServerMessage>();
    private final List<ModeInfo> quiets = new ArrayList<ModeInfo>();
    private final List<String> motd = new ArrayList<String>();
    private final List<ServerMessage> motdMessages = new ArrayList<ServerMessage>();
    private final List<String> monitorList = new ArrayList<String>();
    private final List<ServerMessage> monitorListMessages = new ArrayList<ServerMessage>();
    private final List<CapabilityState> capList = new ArrayList<CapabilityState>();
    private final List<ServerMessage> capListMessages = new ArrayList<ServerMessage>();
    private final List<CapabilityState> capLs = new ArrayList<CapabilityState>();
    private final List<ServerMessage> capLsMessages = new ArrayList<ServerMessage>();
    private static final int CAPABILITY_LIST_INDEX_DEFAULT = 2;

    public DefaultEventListener(Client.WithManagement client) {
        this.client = client;
    }

    @NumericFilter(value=1)
    @Handler(priority=0x7FFFFFFE)
    public void welcome(ClientReceiveNumericEvent event) {
        if (!event.getParameters().isEmpty()) {
            this.client.setCurrentNick(event.getParameters().get(0));
        } else {
            this.trackException(event, "Nickname missing; can't confirm");
        }
    }

    @NumericFilter(value=4)
    @Handler(priority=0x7FFFFFFE)
    public void version(ClientReceiveNumericEvent event) {
        boolean isNotTwitch = this.client.getEventManager().getRegisteredEventListeners().stream().noneMatch(listener -> listener instanceof TwitchListener);
        if (event.getParameters().size() > 1) {
            this.client.getServerInfo().setAddress(event.getParameters().get(1));
            if (event.getParameters().size() > 2) {
                this.client.getServerInfo().setVersion(event.getParameters().get(2));
                if (event.getParameters().size() > 3) {
                    ArrayList<UserMode> modes = new ArrayList<UserMode>(event.getParameters().get(3).length());
                    for (char mode : event.getParameters().get(3).toCharArray()) {
                        modes.add(new DefaultUserMode(this.client, mode));
                    }
                    this.client.getServerInfo().setUserModes(modes);
                } else {
                    this.trackException(event, "Server user modes missing");
                }
            } else if (isNotTwitch) {
                this.trackException(event, "Server version and user modes missing");
            }
        } else {
            this.trackException(event, "Server address, version, and user modes missing");
        }
        if (isNotTwitch) {
            this.client.sendRawLineImmediately("WHOIS " + this.client.getNick());
        }
        this.fire(new ClientNegotiationCompleteEvent(this.client, (Actor)event.getActor(), this.client.getServerInfo()));
        this.client.startSending();
    }

    @NumericFilter(value=5)
    @Handler(priority=0x7FFFFFFE)
    public void iSupport(ClientReceiveNumericEvent event) {
        for (int i = 1; i < event.getParameters().size(); ++i) {
            this.client.getServerInfo().addISupportParameter(this.client.getISupportManager().createParameter(event.getParameters().get(i)));
        }
    }

    @NumericFilter(value=221)
    @Handler(priority=0x7FFFFFFE)
    public void umode(ClientReceiveNumericEvent event) {
        ModeStatusList<UserMode> modes;
        if (event.getParameters().size() < 2) {
            this.trackException(event, "UMODE response too short");
            return;
        }
        if (!this.client.getServerInfo().getCaseMapping().areEqualIgnoringCase(event.getParameters().get(0), this.client.getNick())) {
            this.trackException(event, "UMODE response for another user");
            return;
        }
        try {
            modes = ModeStatusList.fromUser(this.client, StringUtil.combineSplit(event.getParameters().toArray(new String[event.getParameters().size()]), 1));
        }
        catch (IllegalArgumentException e) {
            this.trackException(event, e.getMessage());
            return;
        }
        this.client.setUserModes(modes);
    }

    @NumericFilter.Numerics(value={@NumericFilter(value=305), @NumericFilter(value=306)})
    @Handler(priority=0x7FFFFFFE)
    public void away(ClientReceiveNumericEvent event) {
        this.fire(new ClientAwayStatusChangeEvent(this.client, event.getOriginalMessages(), event.getNumeric() == 306));
    }

    private DefaultWhoisData.Builder getWhoisBuilder(String nick) {
        if (this.whoisBuilder == null || !this.client.getServerInfo().getCaseMapping().areEqualIgnoringCase(this.whoisBuilder.getNick(), nick)) {
            this.whoisBuilder = new DefaultWhoisData.Builder(this.client, nick);
        }
        return this.whoisBuilder;
    }

    @NumericFilter(value=301)
    @Handler(priority=0x7FFFFFFE)
    public void whoisAway(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 3) {
            this.trackException(event, "WHOIS AWAY response too short");
            return;
        }
        this.getWhoisBuilder(event.getParameters().get(1)).setAway(event.getParameters().get(event.getParameters().size() == 3 ? 2 : 3));
    }

    @NumericFilter(value=311)
    @Handler(priority=0x7FFFFFFE)
    public void whoisUser(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "WHOIS USER response too short");
            return;
        }
        DefaultWhoisData.Builder whoisBuilder = this.getWhoisBuilder(event.getParameters().get(1));
        switch (event.getParameters().size()) {
            case 6: {
                whoisBuilder.setRealName(event.getParameters().get(5));
            }
            case 4: {
                whoisBuilder.setHost(event.getParameters().get(3));
            }
            case 3: {
                whoisBuilder.setUserString(event.getParameters().get(2));
            }
        }
    }

    @NumericFilter(value=312)
    @Handler(priority=0x7FFFFFFE)
    public void whoisServer(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 3) {
            this.trackException(event, "WHOIS SERVER response too short");
            return;
        }
        DefaultWhoisData.Builder whoisBuilder = this.getWhoisBuilder(event.getParameters().get(1));
        whoisBuilder.setServer(event.getParameters().get(2));
        if (event.getParameters().size() > 3) {
            whoisBuilder.setServerDescription(event.getParameters().get(3));
        }
    }

    @NumericFilter(value=313)
    @Handler(priority=0x7FFFFFFE)
    public void whoisOperator(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 3) {
            this.trackException(event, "WHOIS OPERATOR response too short");
            return;
        }
        this.getWhoisBuilder(event.getParameters().get(1)).setOperatorInformation(event.getParameters().get(2));
    }

    @NumericFilter(value=317)
    @Handler(priority=0x7FFFFFFE)
    public void whoisIdle(ClientReceiveNumericEvent event) {
        long idleTime;
        if (event.getParameters().size() < 4) {
            this.trackException(event, "WHOIS IDLE response too short");
            return;
        }
        DefaultWhoisData.Builder whoisBuilder = this.getWhoisBuilder(event.getParameters().get(1));
        try {
            idleTime = Long.parseLong(event.getParameters().get(2));
        }
        catch (NumberFormatException e) {
            this.trackException(event, "WHOIS IDLE idle time not a number");
            return;
        }
        whoisBuilder.setIdleTime(idleTime);
        if (event.getParameters().size() > 4) {
            long signOnTime;
            try {
                signOnTime = Long.parseLong(event.getParameters().get(3));
            }
            catch (NumberFormatException e) {
                this.trackException(event, "WHOIS IDLE sign on time not a number");
                return;
            }
            whoisBuilder.setSignOnTime(signOnTime);
        }
    }

    @NumericFilter(value=330)
    @Handler(priority=0x7FFFFFFE)
    public void whoisAccount(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 3) {
            this.trackException(event, "WHOIS ACCOUNT response too short");
            return;
        }
        this.getWhoisBuilder(event.getParameters().get(1)).setAccount(event.getParameters().get(2));
    }

    @NumericFilter(value=319)
    @Handler(priority=0x7FFFFFFE)
    public void whoisChannels(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 3) {
            this.trackException(event, "WHOIS CHANNELS response too short");
            return;
        }
        this.getWhoisBuilder(event.getParameters().get(1)).addChannels(event.getParameters().get(2));
    }

    @NumericFilter(value=671)
    @Handler(priority=0x7FFFFFFE)
    public void whoisSecure(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "WHOIS SECURE response too short");
            return;
        }
        this.getWhoisBuilder(event.getParameters().get(1)).setSecure();
    }

    @NumericFilter(value=318)
    @Handler(priority=0x7FFFFFFE)
    public void whoisEnd(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "WHOIS END response too short");
            return;
        }
        WhoisData whois = this.getWhoisBuilder(event.getParameters().get(1)).build();
        if (this.client.getServerInfo().getCaseMapping().areEqualIgnoringCase(whois.getNick(), this.client.getNick()) && !this.getTracker().getTrackedUser(whois.getNick()).isPresent()) {
            this.getTracker().trackUser(whois);
        }
        this.fire(new WhoisEvent(this.client, whois));
        this.whoisBuilder = null;
    }

    @NumericFilter.Numerics(value={@NumericFilter(value=352), @NumericFilter(value=354)})
    @Handler(priority=0x7FFFFFFE)
    public void who(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < (event.getNumeric() == 352 ? 8 : 9)) {
            this.trackException(event, "WHO response too short");
            return;
        }
        Optional<Channel> channel = this.getTracker().getTrackedChannel(event.getParameters().get(1));
        channel.ifPresent(ch -> {
            String realName;
            String ident = event.getParameters().get(2);
            String host = event.getParameters().get(3);
            String server = event.getParameters().get(4);
            String nick = event.getParameters().get(5);
            User user = (User)this.getTracker().getActor(nick + '!' + ident + '@' + host);
            this.getTracker().trackUser(user);
            this.getTracker().setUserServer(nick, server);
            String status = event.getParameters().get(6);
            switch (event.getNumeric()) {
                case 352: {
                    realName = event.getParameters().get(7);
                    break;
                }
                default: {
                    String account = event.getParameters().get(7);
                    this.getTracker().setUserAccount(nick, "0".equals(account) ? null : account);
                    realName = event.getParameters().get(8);
                }
            }
            this.getTracker().setUserRealName(nick, realName);
            HashSet<ChannelUserMode> modes = new HashSet<ChannelUserMode>();
            block3: for (char prefix : status.substring(1).toCharArray()) {
                if (prefix == 'G') {
                    this.getTracker().setUserAway(nick, true);
                    continue;
                }
                if (prefix == '*') {
                    this.getTracker().setUserOperString(nick, "*");
                    continue;
                }
                for (ChannelUserMode mode : this.client.getServerInfo().getChannelUserModes()) {
                    if (mode.getNickPrefix() != prefix) continue;
                    modes.add(mode);
                    continue block3;
                }
            }
            this.getTracker().trackChannelUser(ch.getName(), user, modes);
            this.whoMessages.add(event.getServerMessage());
        });
    }

    @NumericFilter(value=315)
    @Handler(priority=0x7FFFFFFE)
    public void whoComplete(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "WHO response too short");
            return;
        }
        Optional<Channel> whoChannel = this.getTracker().getTrackedChannel(event.getParameters().get(1));
        whoChannel.ifPresent(channel -> {
            this.getTracker().setChannelListReceived(channel.getName());
            this.whoMessages.add(event.getServerMessage());
            this.fire(new ChannelUsersUpdatedEvent(this.client, this.whoMessages, (Channel)channel));
            this.whoMessages.clear();
        });
    }

    @NumericFilter(value=324)
    @Handler(priority=0x7FFFFFFE)
    public void channelMode(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 3) {
            this.trackException(event, "Channel mode info message too short");
            return;
        }
        Optional<Channel> channel = this.getTracker().getTrackedChannel(event.getParameters().get(1));
        if (channel.isPresent()) {
            ModeStatusList<ChannelMode> statusList;
            try {
                statusList = ModeStatusList.fromChannel(this.client, StringUtil.combineSplit(event.getParameters().toArray(new String[event.getParameters().size()]), 2));
            }
            catch (IllegalArgumentException e) {
                this.trackException(event, e.getMessage());
                return;
            }
            this.getTracker().updateChannelModes(channel.get().getName(), statusList);
        } else {
            this.trackException(event, "Channel mode info message sent for invalid channel name");
        }
    }

    @NumericFilter(value=332)
    @Handler(priority=0x7FFFFFFE)
    public void topic(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "Topic message too short");
            return;
        }
        Optional<Channel> topicChannel = this.getTracker().getTrackedChannel(event.getParameters().get(1));
        if (topicChannel.isPresent()) {
            this.getTracker().setChannelTopic(topicChannel.get().getName(), event.getParameters().get(2));
        } else {
            this.trackException(event, "Topic message sent for invalid channel name");
        }
    }

    @NumericFilter(value=333)
    @Handler(priority=0x7FFFFFFE)
    public void topicInfo(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 4) {
            this.trackException(event, "Topic message too short");
            return;
        }
        Optional<Channel> topicSetChannel = this.getTracker().getTrackedChannel(event.getParameters().get(1));
        if (topicSetChannel.isPresent()) {
            this.getTracker().setChannelTopicInfo(topicSetChannel.get().getName(), Long.parseLong(event.getParameters().get(3)) * 1000L, this.getTracker().getActor(event.getParameters().get(2)));
            this.fire(new ChannelTopicEvent(this.client, event.getOriginalMessages(), topicSetChannel.get(), false));
        } else {
            this.trackException(event, "Topic message sent for invalid channel name");
        }
    }

    @NumericFilter(value=353)
    @Handler(priority=0x7FFFFFFE)
    public void names(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 4) {
            this.trackException(event, "NAMES response too short");
            return;
        }
        Optional<Channel> channel = this.getTracker().getTrackedChannel(event.getParameters().get(2));
        if (channel.isPresent()) {
            List<ChannelUserMode> channelUserModes = this.client.getServerInfo().getChannelUserModes();
            block0: for (String combo : event.getParameters().get(3).split(" ")) {
                HashSet<ChannelUserMode> modes = new HashSet<ChannelUserMode>();
                for (int i = 0; i < combo.length(); ++i) {
                    char c = combo.charAt(i);
                    Optional<ChannelUserMode> mode = channelUserModes.stream().filter(userMode -> userMode.getNickPrefix() == c).findFirst();
                    if (!mode.isPresent()) {
                        this.getTracker().trackChannelNick(channel.get().getName(), combo.substring(i), modes);
                        continue block0;
                    }
                    modes.add(mode.get());
                }
            }
            this.namesMessages.add(event.getServerMessage());
        } else {
            this.trackException(event, "NAMES response sent for invalid channel name");
        }
    }

    @NumericFilter(value=366)
    @Handler(priority=0x7FFFFFFE)
    public void namesComplete(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "NAMES response too short");
            return;
        }
        Optional<Channel> channel = this.getTracker().getTrackedChannel(event.getParameters().get(1));
        if (channel.isPresent()) {
            this.namesMessages.add(event.getServerMessage());
            this.fire(new ChannelNamesUpdatedEvent(this.client, this.namesMessages, channel.get()));
            this.namesMessages.clear();
        } else {
            this.trackException(event, "NAMES response sent for invalid channel name");
        }
    }

    @NumericFilter(value=367)
    @Handler(priority=0x7FFFFFFE)
    public void banList(ClientReceiveNumericEvent event) {
        this.modeInfoList(event, "BANLIST", 'b', this.banMessages, this.bans);
    }

    @NumericFilter(value=346)
    @Handler(priority=0x7FFFFFFE)
    public void inviteList(ClientReceiveNumericEvent event) {
        this.modeInfoList(event, "INVITELIST", 'I', this.inviteMessages, this.invites);
    }

    @NumericFilter(value=348)
    @Handler(priority=0x7FFFFFFE)
    public void exceptList(ClientReceiveNumericEvent event) {
        this.modeInfoList(event, "EXCEPTLIST", 'e', this.exceptMessages, this.excepts);
    }

    @NumericFilter.Numerics(value={@NumericFilter(value=344), @NumericFilter(value=728)})
    @Handler(priority=0x7FFFFFFE)
    public void quietList(ClientReceiveNumericEvent event) {
        this.modeInfoList(event, "QUIETLIST", 'q', this.quietMessages, this.quiets, event.getNumeric() == 344 ? 0 : 1);
    }

    private void modeInfoList(@Nonnull ClientReceiveNumericEvent event, @Nonnull String name, char mode, @Nonnull List<ServerMessage> messageList, @Nonnull List<ModeInfo> infoList) {
        this.modeInfoList(event, name, mode, messageList, infoList, 0);
    }

    private void modeInfoList(@Nonnull ClientReceiveNumericEvent event, @Nonnull String name, char mode, @Nonnull List<ServerMessage> messageList, @Nonnull List<ModeInfo> infoList, int offset) {
        if (event.getParameters().size() < 3 + offset) {
            this.trackException(event, name + " response too short");
            return;
        }
        Optional<Channel> channel = this.getTracker().getTrackedChannel(event.getParameters().get(1));
        if (channel.isPresent()) {
            Optional<ChannelMode> channelMode;
            messageList.add(event.getServerMessage());
            String creator = event.getParameters().size() > 3 + offset ? event.getParameters().get(3 + offset) : null;
            Instant creationTime = null;
            if (event.getParameters().size() > 4 + offset) {
                try {
                    creationTime = Instant.ofEpochSecond(Integer.parseInt(event.getParameters().get(4 + offset)));
                }
                catch (NumberFormatException | DateTimeException runtimeException) {
                    // empty catch block
                }
            }
            if ((channelMode = this.client.getServerInfo().getChannelMode(mode)).isPresent()) {
                infoList.add(new ModeInfo.DefaultModeInfo(this.client, channel.get(), channelMode.get(), event.getParameters().get(2 + offset), creator, creationTime));
            } else {
                this.trackException(event, name + " can't list if there's no '" + mode + "' mode");
            }
        } else {
            this.trackException(event, name + " response sent for invalid channel name");
        }
    }

    @NumericFilter(value=368)
    @Handler(priority=0x7FFFFFFE)
    public void banListEnd(ClientReceiveNumericEvent event) {
        this.endModeInfoList(event, "BANLIST", 'b', this.banMessages, this.bans);
    }

    @NumericFilter(value=347)
    @Handler(priority=0x7FFFFFFE)
    public void inviteListEnd(ClientReceiveNumericEvent event) {
        this.endModeInfoList(event, "INVITELIST", 'I', this.inviteMessages, this.invites);
    }

    @NumericFilter(value=349)
    @Handler(priority=0x7FFFFFFE)
    public void exceptListEnd(ClientReceiveNumericEvent event) {
        this.endModeInfoList(event, "EXCEPTLIST", 'e', this.exceptMessages, this.excepts);
    }

    @NumericFilter.Numerics(value={@NumericFilter(value=345), @NumericFilter(value=729)})
    @Handler(priority=0x7FFFFFFE)
    public void quietListEnd(ClientReceiveNumericEvent event) {
        this.endModeInfoList(event, "QUIETLIST", 'q', this.quietMessages, this.quiets);
    }

    private void endModeInfoList(@Nonnull ClientReceiveNumericEvent event, @Nonnull String name, char mode, @Nonnull List<ServerMessage> messageList, @Nonnull List<ModeInfo> infoList) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, name + " response too short");
            return;
        }
        Optional<Channel> channel = this.getTracker().getTrackedChannel(event.getParameters().get(1));
        if (channel.isPresent()) {
            messageList.add(event.getServerMessage());
            Optional<ChannelMode> channelMode = this.client.getServerInfo().getChannelMode(mode);
            if (channelMode.isPresent()) {
                ArrayList<ModeInfo> modeInfos = new ArrayList<ModeInfo>(infoList);
                this.fire(new ChannelModeInfoListEvent(this.client, messageList, channel.get(), channelMode.get(), modeInfos));
                this.getTracker().setChannelModeInfoList(channel.get().getName(), mode, modeInfos);
            } else {
                this.trackException(event, name + " can't list if there's no '" + mode + "' mode");
            }
            infoList.clear();
            messageList.clear();
        } else {
            this.trackException(event, name + " response sent for invalid channel name");
        }
    }

    @NumericFilter(value=375)
    @Handler(priority=0x7FFFFFFE)
    public void motdStart(ClientReceiveNumericEvent event) {
        this.motd.clear();
        this.motdMessages.clear();
    }

    @NumericFilter(value=372)
    @Handler(priority=0x7FFFFFFE)
    public void motdContent(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "MOTD message too short");
            return;
        }
        this.motd.add(event.getParameters().get(1));
        this.motdMessages.add(event.getServerMessage());
    }

    @NumericFilter(value=376)
    @Handler(priority=0x7FFFFFFE)
    public void motdEnd(ClientReceiveNumericEvent event) {
        this.motdMessages.add(event.getServerMessage());
        this.client.getServerInfo().setMotd(new ArrayList<String>(this.motd));
        this.fire(new ClientReceiveMotdEvent(this.client, this.motdMessages));
    }

    @NumericFilter.Numerics(value={@NumericFilter(value=431), @NumericFilter(value=432), @NumericFilter(value=433)})
    @Handler(priority=0x7FFFFFFE)
    public void nickInUse(ClientReceiveNumericEvent event) {
        NickRejectedEvent nickRejectedEvent = new NickRejectedEvent(this.client, event.getOriginalMessages(), this.client.getRequestedNick(), this.client.getRequestedNick() + '`');
        this.fire(nickRejectedEvent);
        this.client.sendNickChange(nickRejectedEvent.getNewNick());
    }

    @NumericFilter(value=710)
    @Handler(priority=0x7FFFFFFE)
    public void knock(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 3) {
            this.trackException(event, "KNOCK message too short");
            return;
        }
        Optional<Channel> channel = this.getTracker().getTrackedChannel(event.getParameters().get(1));
        if (channel.isPresent()) {
            User user = (User)this.getTracker().getActor(event.getParameters().get(2));
            this.fire(new ChannelKnockEvent((Client)this.client, event.getOriginalMessages(), channel.get(), user));
        } else {
            this.trackException(event, "KNOCK message sent for invalid channel name");
        }
    }

    @NumericFilter.Numerics(value={@NumericFilter(value=730), @NumericFilter(value=731)})
    @Handler(priority=0x7FFFFFFE)
    public void monitorOnline(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "MONITOR status message too short");
            return;
        }
        List<ServerMessage> originalMessages = event.getOriginalMessages();
        for (String nick : event.getParameters().get(1).split(",")) {
            MonitoredNickEventBase monitorEvent = event.getNumeric() == 730 ? new MonitoredNickOnlineEvent(this.client, originalMessages, nick) : new MonitoredNickOfflineEvent(this.client, originalMessages, nick);
            this.fire(monitorEvent);
        }
    }

    @NumericFilter(value=732)
    @Handler(priority=0x7FFFFFFE)
    public void monitorList(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "MONITOR list message too short");
            return;
        }
        Collections.addAll(this.monitorList, event.getParameters().get(1).split(","));
        this.monitorListMessages.add(event.getServerMessage());
    }

    @NumericFilter(value=733)
    @Handler(priority=0x7FFFFFFE)
    public void monitorListEnd(ClientReceiveNumericEvent event) {
        this.fire(new MonitoredNickListEvent(this.client, this.monitorListMessages, this.monitorList));
        this.monitorList.clear();
        this.monitorListMessages.clear();
    }

    @NumericFilter(value=734)
    @Handler(priority=0x7FFFFFFE)
    public void monitorListFull(ClientReceiveNumericEvent event) {
        int limit;
        if (event.getParameters().size() < 3) {
            this.trackException(event, "MONITOR list full message too short");
            return;
        }
        try {
            limit = Integer.parseInt(event.getParameters().get(1));
        }
        catch (NumberFormatException e) {
            this.trackException(event, "MONITOR list full message using non-int limit");
            return;
        }
        this.fire(new MonitoredNickListFullEvent(this.client, event.getOriginalMessages(), limit, Arrays.stream(event.getParameters().get(2).split(",")).collect(Collectors.toList())));
    }

    @CommandFilter(value="CAP")
    @Handler(priority=0x7FFFFFFE)
    public void cap(ClientReceiveCommandEvent event) {
        int capabilityListIndex;
        if (event.getParameters().size() < 3) {
            this.trackException(event, "CAP message too short");
            return;
        }
        CapabilityNegotiationResponseEventBase responseEvent = null;
        if ("*".equals(event.getParameters().get(2))) {
            if (event.getParameters().size() < 4) {
                this.trackException(event, "CAP message too short");
                return;
            }
            capabilityListIndex = 3;
        } else {
            capabilityListIndex = 2;
        }
        List<CapabilityState> capabilityStateList = Arrays.stream(event.getParameters().get(capabilityListIndex).split(" ")).filter(string -> !string.isEmpty()).map(capability -> new DefaultCapabilityState(this.client, (String)capability)).collect(Collectors.toCollection(ArrayList::new));
        switch (event.getParameters().get(1).toLowerCase()) {
            case "ack": {
                this.client.getCapabilityManager().updateCapabilities(capabilityStateList);
                responseEvent = new CapabilitiesAcknowledgedEvent(this.client, event.getOriginalMessages(), this.client.getCapabilityManager().isNegotiating(), capabilityStateList);
                this.fire(responseEvent);
                break;
            }
            case "list": {
                List<CapabilityState> states;
                this.capListMessages.add(event.getServerMessage());
                if (capabilityListIndex != 2) {
                    this.capList.addAll((Collection<CapabilityState>)capabilityStateList);
                    break;
                }
                if (this.capList.isEmpty()) {
                    states = capabilityStateList;
                } else {
                    states = this.capList;
                    states.addAll(capabilityStateList);
                }
                this.client.getCapabilityManager().setCapabilities(states);
                this.fire(new CapabilitiesListEvent(this.client, this.capListMessages, states));
                states.clear();
                break;
            }
            case "ls": {
                List<CapabilityState> states;
                this.capLsMessages.add(event.getServerMessage());
                if (capabilityListIndex != 2) {
                    this.capList.addAll((Collection<CapabilityState>)capabilityStateList);
                    break;
                }
                if (this.capLs.isEmpty()) {
                    states = capabilityStateList;
                } else {
                    states = this.capLs;
                    states.addAll(capabilityStateList);
                }
                this.client.getCapabilityManager().setSupportedCapabilities(states);
                responseEvent = new CapabilitiesSupportedListEvent(this.client, this.capLsMessages, this.client.getCapabilityManager().isNegotiating(), states);
                this.fireAndCapReq((CapabilitiesSupportedListEvent)responseEvent);
                break;
            }
            case "nak": {
                this.client.getCapabilityManager().updateCapabilities(capabilityStateList);
                responseEvent = new CapabilitiesRejectedEvent(this.client, event.getOriginalMessages(), this.client.getCapabilityManager().isNegotiating(), capabilityStateList);
                this.fire(responseEvent);
                break;
            }
            case "new": {
                ArrayList<CapabilityState> statesAdded = new ArrayList<CapabilityState>(this.client.getCapabilityManager().getSupportedCapabilities());
                statesAdded.addAll((Collection<CapabilityState>)capabilityStateList);
                this.client.getCapabilityManager().setSupportedCapabilities(statesAdded);
                responseEvent = new CapabilitiesNewSupportedEvent(this.client, event.getOriginalMessages(), this.client.getCapabilityManager().isNegotiating(), capabilityStateList);
                this.fireAndCapReq((CapabilitiesNewSupportedEvent)responseEvent);
                break;
            }
            case "del": {
                ArrayList<CapabilityState> statesRemaining = new ArrayList<CapabilityState>(this.client.getCapabilityManager().getSupportedCapabilities());
                statesRemaining.removeAll(capabilityStateList);
                this.client.getCapabilityManager().setSupportedCapabilities(statesRemaining);
                responseEvent = new CapabilitiesDeletedSupportedEvent(this.client, event.getOriginalMessages(), this.client.getCapabilityManager().isNegotiating(), capabilityStateList);
                this.fire(responseEvent);
            }
        }
        if (responseEvent != null && responseEvent.isNegotiating() && responseEvent.isEndingNegotiation()) {
            this.client.sendRawLineImmediately("CAP END");
            this.client.getCapabilityManager().endNegotiation();
        }
    }

    private void fireAndCapReq(@Nonnull CapabilityNegotiationResponseEventWithRequestBase responseEvent) {
        Set capabilities = this.client.getCapabilityManager().getSupportedCapabilities().stream().map(CapabilityState::getName).collect(Collectors.toCollection(HashSet::new));
        capabilities.retainAll(CapabilityManager.Defaults.getDefaults());
        capabilities.removeAll(this.client.getCapabilityManager().getCapabilities().stream().map(CapabilityState::getName).collect(Collectors.toList()));
        if (!capabilities.isEmpty()) {
            responseEvent.setEndingNegotiation(false);
            capabilities.forEach(responseEvent::addRequest);
        }
        this.fire(responseEvent);
        List<String> requests = responseEvent.getRequests();
        if (!requests.isEmpty()) {
            CapabilityRequestCommand capabilityRequestCommand = new CapabilityRequestCommand(this.client);
            requests.forEach(capabilityRequestCommand::enable);
            capabilityRequestCommand.execute();
        }
    }

    @CommandFilter(value="CHGHOST")
    @Handler(priority=0x7FFFFFFE)
    public void chghost(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() != 2) {
            this.trackException(event, "Invalid number of parameters for CHGHOST message");
            return;
        }
        if (!(event.getActor() instanceof User)) {
            this.trackException(event, "Invalid actor for CHGHOST message");
            return;
        }
        User user = (User)event.getActor();
        Optional<User> optUser = this.getTracker().getTrackedUser(user.getNick());
        if (!optUser.isPresent()) {
            this.trackException(event, "Null old user for nick");
            return;
        }
        User oldUser = optUser.get();
        String newUserString = event.getParameters().get(0);
        String newHostString = event.getParameters().get(1);
        if (!user.getHost().equals(newHostString)) {
            this.getTracker().trackUserHostnameChange(user.getNick(), newHostString);
            this.fire(new UserHostnameChangeEvent(this.client, event.getOriginalMessages(), oldUser, this.getTracker().getTrackedUser(user.getNick()).get()));
        }
        if (!user.getUserString().equals(newUserString)) {
            this.getTracker().trackUserUserStringChange(user.getNick(), newUserString);
            this.fire(new UserUserStringChangeEvent(this.client, event.getOriginalMessages(), oldUser, this.getTracker().getTrackedUser(user.getNick()).get()));
        }
    }

    @CommandFilter(value="ACCOUNT")
    @Handler(priority=0x7FFFFFFE)
    public void account(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 1) {
            this.trackException(event, "ACCOUNT message too short");
            return;
        }
        if (!(event.getActor() instanceof User)) {
            this.trackException(event, "ACCOUNT message from something other than a user");
            return;
        }
        String accountParameter = event.getParameters().get(0);
        String accountName = "*".equals(accountParameter) ? null : accountParameter;
        this.fire(new UserAccountStatusEvent(this.client, event.getOriginalMessages(), (User)event.getActor(), accountName));
        this.getTracker().setUserAccount(((User)event.getActor()).getNick(), accountName);
    }

    @CommandFilter(value="AWAY")
    @Handler(priority=0x7FFFFFFE)
    public void away(ClientReceiveCommandEvent event) {
        if (!(event.getActor() instanceof User)) {
            this.trackException(event, "AWAY message from something other than a user");
            return;
        }
        String awayMessage = event.getParameters().isEmpty() ? null : StringUtil.combineSplit(event.getParameters().toArray(new String[event.getParameters().size()]), 0);
        this.fire(new UserAwayMessageEvent(this.client, event.getOriginalMessages(), (User)event.getActor(), awayMessage));
        this.getTracker().setUserAway(((User)event.getActor()).getNick(), awayMessage);
    }

    @CommandFilter(value="NOTICE")
    @Handler(priority=0x7FFFFFFE)
    public void notice(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "NOTICE message too short");
            return;
        }
        String message = event.getParameters().get(1);
        if (!(event.getActor() instanceof User)) {
            if (event.getActor() instanceof Server) {
                if (CtcpUtil.isCtcp(message)) {
                    this.trackException(event, "Server sent a CTCP message and I panicked");
                    return;
                }
                this.fire(new ServerNoticeEvent((Client)this.client, event.getOriginalMessages(), (Server)event.getActor(), message));
            } else {
                this.trackException(event, "Message from neither server nor user");
            }
            return;
        }
        if (CtcpUtil.isCtcp(message)) {
            this.ctcp(event);
            return;
        }
        User user = (User)event.getActor();
        MessageTargetInfo messageTargetInfo = this.getTypeByTarget(event.getParameters().get(0));
        if (messageTargetInfo instanceof MessageTargetInfo.Private) {
            this.fire(new PrivateNoticeEvent((Client)this.client, event.getOriginalMessages(), user, event.getParameters().get(0), message));
        } else if (messageTargetInfo instanceof MessageTargetInfo.ChannelInfo) {
            MessageTargetInfo.ChannelInfo channelInfo = (MessageTargetInfo.ChannelInfo)messageTargetInfo;
            this.fire(new ChannelNoticeEvent((Client)this.client, event.getOriginalMessages(), user, channelInfo.getChannel(), message));
        } else if (messageTargetInfo instanceof MessageTargetInfo.TargetedChannel) {
            MessageTargetInfo.TargetedChannel channelInfo = (MessageTargetInfo.TargetedChannel)messageTargetInfo;
            this.fire(new ChannelTargetedNoticeEvent(this.client, event.getOriginalMessages(), user, channelInfo.getChannel(), channelInfo.getPrefix(), message));
        }
    }

    @CommandFilter(value="PRIVMSG")
    @Handler(priority=0x7FFFFFFE)
    public void privmsg(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "PRIVMSG message too short");
            return;
        }
        if (!(event.getActor() instanceof User)) {
            this.trackException(event, "Message from something other than a user");
            return;
        }
        if (CtcpUtil.isCtcp(event.getParameters().get(1))) {
            this.ctcp(event);
            return;
        }
        User user = (User)event.getActor();
        MessageTargetInfo messageTargetInfo = this.getTypeByTarget(event.getParameters().get(0));
        if (messageTargetInfo instanceof MessageTargetInfo.Private) {
            this.fire(new PrivateMessageEvent((Client)this.client, event.getOriginalMessages(), user, event.getParameters().get(0), event.getParameters().get(1)));
        } else if (messageTargetInfo instanceof MessageTargetInfo.ChannelInfo) {
            MessageTargetInfo.ChannelInfo channelInfo = (MessageTargetInfo.ChannelInfo)messageTargetInfo;
            this.fire(new ChannelMessageEvent((Client)this.client, event.getOriginalMessages(), user, channelInfo.getChannel(), event.getParameters().get(1)));
        } else if (messageTargetInfo instanceof MessageTargetInfo.TargetedChannel) {
            MessageTargetInfo.TargetedChannel channelInfo = (MessageTargetInfo.TargetedChannel)messageTargetInfo;
            this.fire(new ChannelTargetedMessageEvent(this.client, event.getOriginalMessages(), user, channelInfo.getChannel(), channelInfo.getPrefix(), event.getParameters().get(1)));
        }
    }

    public void ctcp(ClientReceiveCommandEvent event) {
        String ctcpMessage = CtcpUtil.fromCtcp(event.getParameters().get(1));
        MessageTargetInfo messageTargetInfo = this.getTypeByTarget(event.getParameters().get(0));
        User user = (User)event.getActor();
        switch (event.getCommand()) {
            case "NOTICE": {
                if (!(messageTargetInfo instanceof MessageTargetInfo.Private)) break;
                this.fire(new PrivateCtcpReplyEvent((Client)this.client, event.getOriginalMessages(), user, event.getParameters().get(0), ctcpMessage));
                break;
            }
            case "PRIVMSG": {
                if (messageTargetInfo instanceof MessageTargetInfo.Private) {
                    String reply = null;
                    switch (ctcpMessage) {
                        case "VERSION": {
                            reply = "VERSION I am Kitteh!";
                            break;
                        }
                        case "TIME": {
                            reply = "TIME " + new Date().toString();
                            break;
                        }
                        case "FINGER": {
                            reply = "FINGER om nom nom tasty finger";
                        }
                    }
                    if (ctcpMessage.startsWith("PING ")) {
                        reply = ctcpMessage;
                    }
                    PrivateCtcpQueryEvent ctcpEvent = new PrivateCtcpQueryEvent(this.client, event.getOriginalMessages(), user, event.getParameters().get(0), ctcpMessage, reply);
                    this.fire(ctcpEvent);
                    Optional<String> replyMessage = ctcpEvent.getReply();
                    if (!ctcpEvent.isToClient()) break;
                    replyMessage.ifPresent(message -> this.client.sendRawLine("NOTICE " + user.getNick() + " :" + CtcpUtil.toCtcp(message)));
                    break;
                }
                if (messageTargetInfo instanceof MessageTargetInfo.ChannelInfo) {
                    MessageTargetInfo.ChannelInfo channelInfo = (MessageTargetInfo.ChannelInfo)messageTargetInfo;
                    this.fire(new ChannelCtcpEvent((Client)this.client, event.getOriginalMessages(), user, channelInfo.getChannel(), ctcpMessage));
                    break;
                }
                if (!(messageTargetInfo instanceof MessageTargetInfo.TargetedChannel)) break;
                MessageTargetInfo.TargetedChannel channelInfo = (MessageTargetInfo.TargetedChannel)messageTargetInfo;
                this.fire(new ChannelTargetedCtcpEvent(this.client, event.getOriginalMessages(), user, channelInfo.getChannel(), channelInfo.getPrefix(), ctcpMessage));
            }
        }
    }

    @CommandFilter(value="MODE")
    @Handler(priority=0x7FFFFFFE)
    public void mode(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "MODE message too short");
            return;
        }
        MessageTargetInfo messageTargetInfo = this.getTypeByTarget(event.getParameters().get(0));
        if (messageTargetInfo instanceof MessageTargetInfo.Private) {
            ModeStatusList<UserMode> statusList;
            try {
                statusList = ModeStatusList.fromUser(this.client, StringUtil.combineSplit(event.getParameters().toArray(new String[event.getParameters().size()]), 1));
            }
            catch (IllegalArgumentException e) {
                this.trackException(event, e.getMessage());
                return;
            }
            this.fire(new UserModeEvent(this.client, event.getOriginalMessages(), (Actor)event.getActor(), event.getParameters().get(0), statusList));
            this.client.updateUserModes(statusList);
        } else if (messageTargetInfo instanceof MessageTargetInfo.ChannelInfo) {
            ModeStatusList<ChannelMode> statusList;
            Channel channel = ((MessageTargetInfo.ChannelInfo)messageTargetInfo).getChannel();
            try {
                statusList = ModeStatusList.fromChannel(this.client, StringUtil.combineSplit(event.getParameters().toArray(new String[event.getParameters().size()]), 1));
            }
            catch (IllegalArgumentException e) {
                this.trackException(event, e.getMessage());
                return;
            }
            this.fire(new ChannelModeEvent(this.client, event.getOriginalMessages(), (Actor)event.getActor(), channel, statusList));
            statusList.getStatuses().stream().filter(status -> ((ChannelMode)status.getMode()).getType() == ChannelMode.Type.A_MASK).forEach(status -> this.getTracker().trackChannelModeInfo(channel.getName(), status.isSetting(), new ModeInfo.DefaultModeInfo(this.client, channel, (ChannelMode)status.getMode(), status.getParameter().get(), event.getActor().getName(), Instant.now())));
            this.getTracker().updateChannelModes(channel.getName(), statusList);
        } else {
            this.trackException(event, "MODE message sent for invalid target");
        }
    }

    @CommandFilter(value="JOIN")
    @Handler(priority=0x7FFFFFFE)
    public void join(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 1) {
            this.trackException(event, "JOIN message too short");
            return;
        }
        String channelName = event.getParameters().get(0);
        if (this.client.getServerInfo().isValidChannel(channelName)) {
            if (event.getActor() instanceof User) {
                this.getTracker().trackChannel(channelName);
                Channel channel = this.getTracker().getTrackedChannel(channelName).get();
                User user = (User)event.getActor();
                this.getTracker().trackChannelUser(channelName, user, new HashSet<ChannelUserMode>());
                ChannelJoinEvent joinEvent = null;
                if (user.getNick().equals(this.client.getNick())) {
                    if (this.client.getActorTracker().shouldQueryChannelInformation()) {
                        this.client.sendRawLine("MODE " + channelName);
                        this.client.sendRawLine("WHO " + channelName + (this.client.getServerInfo().hasWhoXSupport() ? " %cuhsnfar" : ""));
                    }
                    if (this.client.getIntendedChannels().contains(channelName)) {
                        joinEvent = new RequestedChannelJoinCompleteEvent((Client)this.client, event.getOriginalMessages(), channel, user);
                    }
                }
                if (event.getParameters().size() > 2) {
                    if (!"*".equals(event.getParameters().get(1))) {
                        this.getTracker().setUserAccount(user.getNick(), event.getParameters().get(1));
                    }
                    this.getTracker().setUserRealName(user.getNick(), event.getParameters().get(2));
                }
                if (joinEvent == null) {
                    joinEvent = new ChannelJoinEvent((Client)this.client, event.getOriginalMessages(), channel, user);
                }
                this.fire(joinEvent);
            } else {
                this.trackException(event, "JOIN message sent for non-user");
            }
        } else {
            this.trackException(event, "JOIN message sent for invalid channel name");
        }
    }

    @CommandFilter(value="PART")
    @Handler(priority=0x7FFFFFFE)
    public void part(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 1) {
            this.trackException(event, "PART message too short");
            return;
        }
        Optional<Channel> channel = this.getTracker().getTrackedChannel(event.getParameters().get(0));
        if (channel.isPresent()) {
            if (event.getActor() instanceof User) {
                User user = (User)event.getActor();
                boolean isSelf = user.getNick().equals(this.client.getNick());
                String partReason = event.getParameters().size() > 1 ? event.getParameters().get(1) : "";
                ChannelPartEvent partEvent = isSelf && this.client.getIntendedChannels().contains(channel.get().getName()) ? new UnexpectedChannelLeaveViaPartEvent((Client)this.client, event.getOriginalMessages(), channel.get(), user, partReason) : new ChannelPartEvent((Client)this.client, event.getOriginalMessages(), channel.get(), user, partReason);
                this.fire(partEvent);
                this.getTracker().trackUserPart(channel.get().getName(), user.getNick());
                if (isSelf) {
                    this.getTracker().unTrackChannel(channel.get().getName());
                }
            } else {
                this.trackException(event, "PART message sent for non-user");
            }
        } else {
            this.trackException(event, "PART message sent for invalid channel name");
        }
    }

    @CommandFilter(value="QUIT")
    @Handler(priority=0x7FFFFFFE)
    public void quit(ClientReceiveCommandEvent event) {
        if (event.getActor() instanceof User) {
            this.fire(new UserQuitEvent((Client)this.client, event.getOriginalMessages(), (User)event.getActor(), event.getParameters().isEmpty() ? "" : event.getParameters().get(0)));
            this.getTracker().trackUserQuit(((User)event.getActor()).getNick());
        } else {
            this.trackException(event, "QUIT message sent for non-user");
        }
    }

    @CommandFilter(value="KICK")
    @Handler(priority=0x7FFFFFFE)
    public void kick(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "KICK message too short");
            return;
        }
        Optional<Channel> channel = this.getTracker().getTrackedChannel(event.getParameters().get(0));
        if (channel.isPresent()) {
            Optional<User> kickedUser = this.getTracker().getTrackedUser(event.getParameters().get(1));
            if (kickedUser.isPresent()) {
                boolean isSelf = event.getParameters().get(1).equals(this.client.getNick());
                String kickReason = event.getParameters().size() > 2 ? event.getParameters().get(2) : "";
                ChannelKickEvent kickEvent = isSelf && this.client.getIntendedChannels().contains(channel.get().getName()) ? new UnexpectedChannelLeaveViaKickEvent(this.client, event.getOriginalMessages(), channel.get(), (Actor)event.getActor(), kickedUser.get(), kickReason) : new ChannelKickEvent(this.client, event.getOriginalMessages(), channel.get(), (Actor)event.getActor(), kickedUser.get(), kickReason);
                this.fire(kickEvent);
                this.getTracker().trackUserPart(channel.get().getName(), event.getParameters().get(1));
                if (isSelf) {
                    this.getTracker().unTrackChannel(channel.get().getName());
                }
            } else {
                this.trackException(event, "KICK message sent for non-user");
            }
        } else {
            this.trackException(event, "KICK message sent for invalid channel name");
        }
    }

    @CommandFilter(value="NICK")
    @Handler(priority=0x7FFFFFFE)
    public void nick(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 1) {
            this.trackException(event, "NICK message too short");
            return;
        }
        if (event.getActor() instanceof User) {
            boolean isSelf = ((User)event.getActor()).getNick().equals(this.client.getNick());
            Optional<User> user = this.getTracker().getTrackedUser(((User)event.getActor()).getNick());
            if (!user.isPresent()) {
                if (isSelf) {
                    this.client.setCurrentNick(event.getParameters().get(0));
                    return;
                }
                this.trackException(event, "NICK message sent for user not in tracked channels");
                return;
            }
            User oldUser = user.get();
            this.getTracker().trackUserNickChange(user.get().getNick(), event.getParameters().get(0));
            User newUser = user.get();
            this.fire(new UserNickChangeEvent(this.client, event.getOriginalMessages(), oldUser, newUser));
            if (isSelf) {
                this.client.setCurrentNick(event.getParameters().get(0));
            }
        } else {
            this.trackException(event, "NICK message sent for non-user");
        }
    }

    @CommandFilter(value="INVITE")
    @Handler(priority=0x7FFFFFFE)
    public void invite(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "INVITE message too short");
            return;
        }
        Optional<Channel> channel = this.getTracker().getTrackedChannel(event.getParameters().get(1));
        if (channel.isPresent()) {
            if (this.client.getNick().equalsIgnoreCase(event.getParameters().get(0)) && this.client.getIntendedChannels().contains(channel.get().getName())) {
                this.client.sendRawLine("JOIN " + channel.get().getName());
            }
            this.fire(new ChannelInviteEvent(this.client, event.getOriginalMessages(), channel.get(), (Actor)event.getActor(), event.getParameters().get(0)));
        } else {
            this.trackException(event, "INVITE message sent for invalid channel name");
        }
    }

    @CommandFilter(value="TOPIC")
    @Handler(priority=0x7FFFFFFE)
    public void topic(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "TOPIC message too short");
            return;
        }
        Optional<Channel> channel = this.getTracker().getTrackedChannel(event.getParameters().get(0));
        if (channel.isPresent()) {
            this.getTracker().setChannelTopic(channel.get().getName(), event.getParameters().get(1));
            this.getTracker().setChannelTopicInfo(channel.get().getName(), System.currentTimeMillis(), (Actor)event.getActor());
            this.fire(new ChannelTopicEvent(this.client, event.getOriginalMessages(), channel.get(), true));
        } else {
            this.trackException(event, "TOPIC message sent for invalid channel name");
        }
    }

    @CommandFilter(value="WALLOPS")
    @Handler(priority=0x7FFFFFFE)
    public void wallops(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 1) {
            this.trackException(event, "WALLOPS message too short");
            return;
        }
        this.fire(new WallopsEvent((Client)this.client, event.getOriginalMessages(), (Actor)event.getActor(), event.getParameters().get(0)));
    }

    @Nonnull
    public String toString() {
        return new ToStringer(this).toString();
    }

    protected void fire(ClientEvent event) {
        this.client.getEventManager().callEvent(event);
    }

    @Nonnull
    protected MessageTargetInfo getTypeByTarget(@Nonnull String target) {
        Optional<Channel> channel = this.getTracker().getTrackedChannel(target);
        Optional<ChannelUserMode> prefix = this.client.getServerInfo().getTargetedChannelInfo(target);
        if (prefix.isPresent()) {
            return new MessageTargetInfo.TargetedChannel(this.getTracker().getTrackedChannel(target.substring(1)).get(), prefix.get());
        }
        if (channel.isPresent()) {
            return new MessageTargetInfo.ChannelInfo(channel.get());
        }
        return MessageTargetInfo.Private.INSTANCE;
    }

    protected void trackException(ClientReceiveServerMessageEvent event, String reason) {
        this.client.getExceptionListener().queue(new KittehServerMessageException(event.getServerMessage(), reason));
    }

    protected ActorTracker getTracker() {
        return this.client.getActorTracker();
    }

    protected static class MessageTargetInfo {
        protected MessageTargetInfo() {
        }

        protected static class Private
        extends MessageTargetInfo {
            static final Private INSTANCE = new Private();

            protected Private() {
            }

            @Nonnull
            public String toString() {
                return new ToStringer(this).toString();
            }
        }

        protected static class TargetedChannel
        extends MessageTargetInfo {
            private final Channel channel;
            private final ChannelUserMode prefix;

            protected TargetedChannel(Channel channel, ChannelUserMode prefix) {
                this.channel = channel;
                this.prefix = prefix;
            }

            @Nonnull
            protected Channel getChannel() {
                return this.channel;
            }

            @Nonnull
            protected ChannelUserMode getPrefix() {
                return this.prefix;
            }

            @Nonnull
            public String toString() {
                return new ToStringer(this).toString();
            }
        }

        protected static class ChannelInfo
        extends MessageTargetInfo {
            private final Channel channel;

            protected ChannelInfo(Channel channel) {
                this.channel = channel;
            }

            @Nonnull
            protected Channel getChannel() {
                return this.channel;
            }

            @Nonnull
            public String toString() {
                return new ToStringer(this).toString();
            }
        }
    }
}

